/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.references;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingActionIf;
import ghidra.app.plugin.core.references.AddExternalReferenceNameAction;
import ghidra.app.plugin.core.references.ClearExternalNameAssociationAction;
import ghidra.app.plugin.core.references.DeleteExternalReferenceNameAction;
import ghidra.app.plugin.core.references.ExternalNamesTableModel;
import ghidra.app.plugin.core.references.ReferencesPlugin;
import ghidra.app.plugin.core.references.SetExternalNameAssociationAction;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.table.GhidraTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.table.TableModel;

public class ExternalReferencesProvider
extends ComponentProviderAdapter {
    private JPanel mainPanel;
    private ExternalNamesTableModel tableModel;
    private GhidraTable table;
    private Program program;
    private DomainObjectListener domainObjectListener = ev -> {
        if (this.isVisible()) {
            this.tableModel.updateTableData();
        }
    };
    private AddExternalReferenceNameAction addExternalAction;
    private DeleteExternalReferenceNameAction deleteExternalAction;
    private SetExternalNameAssociationAction setAssocationAction;
    private ClearExternalNameAssociationAction clearAssociationAction;

    public ExternalReferencesProvider(ReferencesPlugin plugin) {
        super(plugin.getTool(), "External Programs", plugin.getName());
        this.mainPanel = this.buildMainPanel();
        this.setHelpLocation(new HelpLocation("ReferencesPlugin", "ExternalNamesDialog"));
        this.addToTool();
        this.addExternalAction = new AddExternalReferenceNameAction(this);
        this.deleteExternalAction = new DeleteExternalReferenceNameAction(this);
        this.setAssocationAction = new SetExternalNameAssociationAction(this);
        this.clearAssociationAction = new ClearExternalNameAssociationAction(this);
        this.addLocalAction((DockingActionIf)this.addExternalAction);
        this.addLocalAction((DockingActionIf)this.setAssocationAction);
        this.addLocalAction((DockingActionIf)this.clearAssociationAction);
        this.addLocalAction((DockingActionIf)this.deleteExternalAction);
        this.updateActionEnablement();
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    void setProgram(Program program) {
        if (this.program != null) {
            this.program.removeListener(this.domainObjectListener);
        }
        this.program = program;
        if (this.program != null) {
            this.program.addListener(this.domainObjectListener);
        }
        if (this.isVisible()) {
            this.tableModel.setProgram(program);
        }
        this.updateActionEnablement();
    }

    public void componentHidden() {
        this.tableModel.setProgram(null);
    }

    public void componentShown() {
        this.tableModel.setProgram(this.program);
    }

    public ActionContext getActionContext(MouseEvent event) {
        return new ActionContext((ComponentProvider)this, (Component)((Object)this.table));
    }

    private JPanel buildMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.tableModel = new ExternalNamesTableModel(this.tool);
        this.table = new GhidraTable((TableModel)((Object)this.tableModel));
        KeyStroke enter = KeyStroke.getKeyStroke("ENTER");
        for (InputMap inputMap = this.table.getInputMap(1); inputMap != null; inputMap = inputMap.getParent()) {
            inputMap.remove(enter);
        }
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                int selectedRowCount = ExternalReferencesProvider.this.table.getSelectedRowCount();
                if (selectedRowCount != 1) {
                    return;
                }
                if (e.getKeyCode() == 10) {
                    int row = ExternalReferencesProvider.this.table.getSelectedRow();
                    ExternalReferencesProvider.this.table.editCellAt(row, 0);
                    Component editorComponent = ExternalReferencesProvider.this.table.getEditorComponent();
                    if (editorComponent != null) {
                        editorComponent.requestFocus();
                    }
                }
            }
        });
        this.table.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.updateActionEnablement();
        });
        JScrollPane sp = new JScrollPane((Component)((Object)this.table));
        this.table.setSelectionMode(2);
        this.table.setAutoResizeMode(4);
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this.table));
        panel.add((Component)sp, "Center");
        return panel;
    }

    private void updateActionEnablement() {
        this.deleteExternalAction.setEnabled(this.table.getSelectedRowCount() > 0);
        this.clearAssociationAction.setEnabled(this.table.getSelectedRowCount() > 0);
        this.setAssocationAction.setEnabled(this.table.getSelectedRowCount() == 1);
        this.addExternalAction.setEnabled(this.program != null);
    }

    public Program getProgram() {
        return this.program;
    }

    public List<String> getSelectedExternalNames() {
        int[] selectedRows;
        ArrayList<String> externalNames = new ArrayList<String>();
        for (int row : selectedRows = this.table.getSelectedRows()) {
            String externalName = (String)this.tableModel.getValueAt(row, 0);
            externalNames.add(externalName);
        }
        return externalNames;
    }

    public PluginTool getTool() {
        return this.tool;
    }

    void dispose() {
        this.table.dispose();
    }
}

