/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.actions;

import docking.action.MenuData;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.core.symboltree.SymbolTreeActionContext;
import ghidra.app.plugin.core.symboltree.actions.SymbolTreeContextAction;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;

public class SelectionAction
extends SymbolTreeContextAction {
    private Plugin plugin;

    public SelectionAction(Plugin plugin) {
        super("Make Selection", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Make Selection"}, "0Middle"));
    }

    @Override
    protected boolean isEnabledForContext(SymbolTreeActionContext context) {
        for (Symbol s : context.getSymbols()) {
            if (s.isExternal()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(SymbolTreeActionContext context) {
        AddressSet set = new AddressSet();
        for (Symbol symbol : context.getSymbols()) {
            if (symbol.isExternal()) continue;
            Object symbolObject = symbol.getObject();
            if (symbolObject instanceof Namespace) {
                Namespace namespace = (Namespace)symbolObject;
                set.add(namespace.getBody());
                continue;
            }
            if (symbolObject instanceof Variable) {
                ProgramLocation loc = symbol.getProgramLocation();
                set.addRange(loc.getAddress(), loc.getAddress());
                continue;
            }
            if (!(symbolObject instanceof CodeUnit)) continue;
            CodeUnit cu = (CodeUnit)symbolObject;
            set.addRange(cu.getMinAddress(), cu.getMaxAddress());
        }
        if (!set.isEmpty()) {
            this.plugin.firePluginEvent((PluginEvent)new ProgramSelectionPluginEvent(this.plugin.getName(), new ProgramSelection((AddressSetView)set), context.getProgram()));
        }
    }
}

