/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.next;

import ghidra.app.util.bin.format.dwarf4.DIEAggregate;
import ghidra.app.util.bin.format.dwarf4.DWARFCompilationUnit;
import ghidra.app.util.bin.format.dwarf4.DWARFException;
import ghidra.app.util.bin.format.dwarf4.next.DWARFProgram;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DIEAMonitoredIterator {
    public static Iterable<DIEAggregate> iterable(final DWARFProgram prog, final String monitorMessage, final TaskMonitor monitor) {
        return new Iterable<DIEAggregate>(){

            @Override
            public Iterator<DIEAggregate> iterator() {
                return prog.getImportOptions().isPreloadAllDIEs() ? new SimpleDIEAMonitoredIterator(prog, monitorMessage, monitor) : new PagedDIEAMonitoredIterator(prog, monitorMessage, monitor);
            }
        };
    }

    static class PagedDIEAMonitoredIterator
    implements Iterator<DIEAggregate> {
        private TaskMonitor monitor;
        private DWARFProgram prog;
        private String monitorMessage;
        private Iterator<DWARFCompilationUnit> cuIterator;
        private DWARFCompilationUnit cu;
        private Iterator<DIEAggregate> aggregateIterator;
        private int cuCount;
        private int aggregateTotalCount;

        public PagedDIEAMonitoredIterator(DWARFProgram prog, String monitorMessage, TaskMonitor monitor) {
            this.prog = prog;
            this.monitor = monitor;
            this.monitorMessage = monitorMessage;
            this.cuCount = prog.getCompilationUnits().size();
            this.aggregateTotalCount = prog.getTotalAggregateCount();
            this.cuIterator = prog.getCompilationUnits().iterator();
            monitor.setIndeterminate(false);
            monitor.setShowProgressValue(true);
            monitor.initialize((long)this.aggregateTotalCount);
            monitor.setMessage(monitorMessage);
        }

        private void updateMonitorMessage() {
            this.monitor.setMaximum((long)this.aggregateTotalCount);
            this.monitor.setMessage(this.monitorMessage + " - Compilation Unit #" + this.cu.getCompUnitNumber() + "/" + this.cuCount);
        }

        private void finalizeMonitorMessage() {
            this.monitor.setMessage(this.monitorMessage + " - Done");
        }

        @Override
        public boolean hasNext() {
            while (true) {
                if (this.aggregateIterator == null) {
                    if (this.cuIterator.hasNext()) {
                        this.cu = this.cuIterator.next();
                        try {
                            this.prog.setCurrentCompilationUnit(this.cu, this.monitor);
                        }
                        catch (DWARFException | IOException e) {
                            Msg.warn((Object)this, (Object)("Error when reading DIE entries for CU #" + this.cu.getCompUnitNumber()), (Throwable)e);
                            return false;
                        }
                        catch (CancelledException e) {
                            return false;
                        }
                        this.aggregateIterator = this.prog.getAggregates().iterator();
                        this.updateMonitorMessage();
                    } else {
                        this.finalizeMonitorMessage();
                        return false;
                    }
                }
                if (this.aggregateIterator.hasNext()) {
                    return true;
                }
                this.aggregateIterator = null;
            }
        }

        @Override
        public DIEAggregate next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            DIEAggregate diea = this.aggregateIterator.next();
            this.monitor.incrementProgress(1L);
            return diea;
        }
    }

    static class SimpleDIEAMonitoredIterator
    implements Iterator<DIEAggregate> {
        private Iterator<DIEAggregate> aggregateIterator;
        private int aggregateTotalCount;
        private TaskMonitor monitor;
        private String monitorMessage;

        public SimpleDIEAMonitoredIterator(DWARFProgram prog, String monitorMessage, TaskMonitor monitor) {
            this.monitor = monitor;
            this.monitorMessage = monitorMessage;
            this.aggregateTotalCount = prog.getTotalAggregateCount();
            this.aggregateIterator = prog.getAggregates().iterator();
            monitor.setIndeterminate(false);
            monitor.setShowProgressValue(true);
            monitor.initialize((long)this.aggregateTotalCount);
            monitor.setMessage(monitorMessage);
        }

        @Override
        public boolean hasNext() {
            return this.aggregateIterator.hasNext();
        }

        @Override
        public DIEAggregate next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            DIEAggregate diea = this.aggregateIterator.next();
            this.monitor.setMaximum((long)this.aggregateTotalCount);
            this.monitor.setMessage(this.monitorMessage);
            this.monitor.incrementProgress(1L);
            return diea;
        }
    }
}

