/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands.dyld;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.DyldInfoCommand;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;
import java.io.ByteArrayInputStream;

public abstract class AbstractDyldInfoProcessor {
    protected MachHeader header;
    protected Program program;
    protected ByteProvider provider;
    protected DyldInfoCommand command;

    protected AbstractDyldInfoProcessor(MachHeader header, Program program, ByteProvider provider, DyldInfoCommand command) {
        this.header = header;
        this.program = program;
        this.provider = provider;
        this.command = command;
    }

    public abstract void process(TaskMonitor var1) throws Exception;

    protected long uleb128(ByteArrayInputStream byteStream, TaskMonitor monitor) throws Exception {
        int value;
        long result = 0L;
        int bit = 0;
        while (!monitor.isCancelled() && (value = byteStream.read()) != -1) {
            byte b = (byte)value;
            long slice = b & 0x7F;
            if ((b & 0x80) == 128 && (bit >= 64 || slice << bit >> bit != slice)) {
                throw new RuntimeException("uleb128 too big");
            }
            result |= slice << bit;
            bit += 7;
            if ((b & 0x80) != 0) continue;
            break;
        }
        return result;
    }

    protected long sleb128(ByteArrayInputStream byteStream, TaskMonitor monitor) throws Exception {
        int value;
        long result = 0L;
        int bit = 0;
        while (!monitor.isCancelled() && (value = byteStream.read()) != -1) {
            byte nextByte = (byte)value;
            result |= (long)((nextByte & 0x7F) << bit);
            bit += 7;
            if ((nextByte & 0x80) != 0) continue;
            break;
        }
        return result;
    }

    protected String readString(ByteArrayInputStream byteStream, TaskMonitor monitor) {
        byte b;
        int value;
        StringBuffer buffer = new StringBuffer();
        while (!monitor.isCancelled() && (value = byteStream.read()) != -1 && (b = (byte)value) != 0) {
            buffer.append((char)(b & 0xFF));
        }
        return buffer.toString();
    }
}

