/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.app.util.bin.format.pe.cli.tables.indexes.CliIndexCustomAttributeType;
import ghidra.app.util.bin.format.pe.cli.tables.indexes.CliIndexHasCustomAttribute;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

public class CliTableCustomAttribute
extends CliAbstractTable {
    public CliTableCustomAttribute(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            CliCustomAttributeRow row = new CliCustomAttributeRow(CliIndexHasCustomAttribute.readCodedIndex(reader, stream), CliIndexCustomAttributeType.readCodedIndex(reader, stream), this.readBlobIndex(reader));
            this.rows.add(row);
            this.blobs.add(row.valueIndex);
        }
        reader.setPointerIndex(this.readerOffset);
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "CustomAttribute Row", 0);
        rowDt.add(CliIndexHasCustomAttribute.toDataType(this.metadataStream), "Parent", null);
        rowDt.add(CliIndexCustomAttributeType.toDataType(this.metadataStream), "Type", null);
        rowDt.add(this.metadataStream.getBlobIndexDataType(), "Value", null);
        return rowDt;
    }

    public class CliCustomAttributeRow
    extends CliAbstractTableRow {
        public int parentIndex;
        public int typeIndex;
        public int valueIndex;

        public CliCustomAttributeRow(int parentIndex, int typeIndex, int valueIndex) {
            this.parentIndex = parentIndex;
            this.typeIndex = typeIndex;
            this.valueIndex = valueIndex;
        }

        @Override
        public String getRepresentation() {
            String typeRep;
            String parentRep;
            try {
                parentRep = CliTableCustomAttribute.this.getRowRepresentationSafe(CliIndexHasCustomAttribute.getTableName(this.parentIndex), CliIndexHasCustomAttribute.getRowIndex(this.parentIndex));
            }
            catch (InvalidInputException e) {
                parentRep = Integer.toHexString(this.parentIndex);
            }
            try {
                typeRep = CliTableCustomAttribute.this.getRowRepresentationSafe(CliIndexCustomAttributeType.getTableName(this.parentIndex), CliIndexCustomAttributeType.getRowIndex(this.parentIndex));
            }
            catch (InvalidInputException e) {
                typeRep = Integer.toHexString(this.typeIndex);
            }
            return String.format("Parent %s Type %s Value %x", parentRep, typeRep, this.valueIndex);
        }
    }
}

