/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables.indexes;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.WordDataType;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

public class CliCodedIndexUtils {
    public static DataType toDataType(CliStreamMetadata stream, int bitsUsed, CliTypeTable[] tables) {
        int maxForWord = (1 << WordDataType.dataType.getLength() * 8 - bitsUsed) - 1;
        for (CliTypeTable table : tables) {
            if (table == null || stream.getNumberRowsForTable(table) <= maxForWord) continue;
            return DWordDataType.dataType;
        }
        return WordDataType.dataType;
    }

    public static CliTypeTable getTableName(int codedIndex, int bitsUsed, CliTypeTable[] tables) throws InvalidInputException {
        int mask = (2 << bitsUsed - 1) - 1;
        int tableBits = codedIndex & mask;
        if (tableBits >= tables.length) {
            throw new InvalidInputException("The coded index is not valid for this index type. There is no TableName for the bit pattern.");
        }
        return tables[tableBits];
    }

    public static int getRowIndex(int codedIndex, int bitsUsed) {
        return codedIndex >> bitsUsed;
    }

    public static int readCodedIndex(BinaryReader reader, CliStreamMetadata stream, int bitsUsed, CliTypeTable[] tables) throws IOException {
        if (CliCodedIndexUtils.toDataType(stream, bitsUsed, tables).getLength() == WordDataType.dataType.getLength()) {
            return reader.readNextShort();
        }
        return reader.readNextInt();
    }
}

