/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pef;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pef.ContainerHeader;
import ghidra.app.util.bin.format.pef.ImportStateCache;
import ghidra.app.util.bin.format.pef.ImportedLibrary;
import ghidra.app.util.bin.format.pef.ImportedSymbol;
import ghidra.app.util.bin.format.pef.Relocation;
import ghidra.app.util.bin.format.pef.RelocationState;
import ghidra.app.util.bin.format.pef.SectionHeader;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;

public class RelocByIndexGroup
extends Relocation {
    public static final int kPEFRelocSmByImport = 0;
    public static final int kPEFRelocSmSetSectC = 1;
    public static final int kPEFRelocSmSetSectD = 2;
    public static final int kPEFRelocSmBySection = 3;
    private int subopcode;
    private int index;

    RelocByIndexGroup(BinaryReader reader) throws IOException {
        int value = reader.readNextShort() & 0xFFFF;
        this.opcode = (value & 0xE000) >> 13;
        this.subopcode = (value & 0x1E00) >> 9;
        this.index = value & 0x1FF;
    }

    @Override
    public boolean isMatch() {
        return this.opcode == 3;
    }

    public int getSubopcode() {
        return this.subopcode;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String toString() {
        switch (this.subopcode) {
            case 0: {
                return "RelocSmByImport";
            }
            case 1: {
                return "RelocSmSetSectC";
            }
            case 2: {
                return "RelocSmSetSectD";
            }
            case 3: {
                return "RelocSmBySection";
            }
        }
        return super.toString();
    }

    @Override
    public void apply(ImportStateCache importState, RelocationState relocState, ContainerHeader header, Program program, MessageLog log, TaskMonitor monitor) {
        List<ImportedSymbol> importedSymbols = header.getLoader().getImportedSymbols();
        switch (this.subopcode) {
            case 0: {
                ImportedSymbol importedSymbol = importedSymbols.get(this.index);
                ImportedLibrary library = header.getLoader().findLibrary(this.index);
                String importedSymbolName = SymbolUtilities.replaceInvalidChars((String)importedSymbol.getName(), (boolean)true);
                Symbol symbol = importState.getSymbol(importedSymbolName, library);
                relocState.relocateMemoryAt(relocState.getRelocationAddress(), (int)symbol.getAddress().getOffset(), log);
                relocState.incrementRelocationAddress(4);
                relocState.setImportIndex(this.index + 1);
                break;
            }
            case 1: {
                SectionHeader sectC = header.getSections().get(this.index);
                MemoryBlock blockC = importState.getMemoryBlockForSection(sectC);
                relocState.setSectionC(blockC.getStart());
                break;
            }
            case 2: {
                SectionHeader sectD = header.getSections().get(this.index);
                MemoryBlock blockD = importState.getMemoryBlockForSection(sectD);
                relocState.setSectionD(blockD.getStart());
                break;
            }
            case 3: {
                SectionHeader sect = header.getSections().get(this.index);
                MemoryBlock block = importState.getMemoryBlockForSection(sect);
                relocState.relocateMemoryAt(relocState.getRelocationAddress(), (int)block.getStart().getOffset(), log);
                break;
            }
            default: {
                log.appendMsg("Unsupported RelocByIndexGroup subopcode: " + this.subopcode);
            }
        }
    }
}

