/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.exporter;

import ghidra.app.util.Option;
import ghidra.app.util.OptionException;
import ghidra.framework.options.SaveState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ProgramTextOptions {
    static final String OPTION_WIDTH = "Width";
    static final String OPTION_WIDTH_ADDR = " Address ";
    static final String OPTION_WIDTH_BYTES = " Bytes ";
    static final String OPTION_WIDTH_PREMNEMONIC = " PreMnemonic ";
    static final String OPTION_WIDTH_MNEMONIC = " Mnemonic ";
    static final String OPTION_WIDTH_OPERAND = " Operand ";
    static final String OPTION_WIDTH_EOL = " End of Line ";
    static final String OPTION_WIDTH_LABEL = " Labels ";
    static final String OPTION_WIDTH_REF = " References ";
    static final String OPTION_WIDTH_DATA_FIELD = " Data Field Name ";
    static final String OPTION_SHOW = "Show";
    static final String OPTION_SHOW_COMMENTS = " Comments ";
    static final String OPTION_SHOW_PROPERTIES = " Properties ";
    static final String OPTION_SHOW_STRUCTURES = " Structures ";
    static final String OPTION_SHOW_UNDEFINED = " Undefined Data ";
    static final String OPTION_SHOW_REF_HEADER = " Ref Headers ";
    static final String OPTION_SHOW_BACK_REFS = " Back Refs ";
    static final String OPTION_SHOW_FORWARD_REFS = " Forward Refs ";
    static final String OPTION_SHOW_FUNCTIONS = " Functions ";
    static final String OPTION_SHOW_BLOCK_NAMES = " Block Names ";
    static final String OPTION_ADV = "Advanced";
    static final String OPTION_ADV_LABEL_SUFFIX = " Label Suffix ";
    static final String OPTION_ADV_COMMENT_SUFFIX = " Comment Prefix ";
    private static final int DEFAULT_ADDR_WIDTH = 16;
    private static final int DEFAULT_BYTES_WIDTH = 12;
    private static final int DEFAULT_LABEL_WIDTH = 30;
    private static final int DEFAULT_PREMNEMONIC_WIDTH = 4;
    private static final int DEFAULT_MNEMONIC_WIDTH = 12;
    private static final int DEFAULT_OPERAND_WIDTH = 40;
    private static final int DEFAULT_EOL_WIDTH = 40;
    private static final int DEFAULT_REF_HEADER_WIDTH = 13;
    private static final int DEFAULT_REF_WIDTH = 40;
    private static final int DEFAULT_STACK_VAR_PRENAME_WIDTH = 10;
    private static final int DEFAULT_STACK_VAR_NAME_WIDTH = 15;
    private static final int DEFAULT_STACK_VAR_DATATYPE_WIDTH = 15;
    private static final int DEFAULT_STACK_VAR_OFFSET_WIDTH = 8;
    private static final int DEFAULT_STACK_VAR_COMMENT_WIDTH = 20;
    private static final int DEFAULT_STACK_VAR_XREF_WIDTH = 50;
    private static final int DEFAULT_DATA_FIELD_NAME_WIDTH = 12;
    private static final String DEFAULT_LABEL_SUFFIX = ":";
    private static final String DEFAULT_COMMENT_PREFIX = ";";
    private boolean isHTML;
    private int addrWidth = 16;
    private int bytesWidth = 12;
    private int labelWidth = 30;
    private int preMnemonicWidth = 4;
    private int mnemonicWidth = 12;
    private int operandWidth = 40;
    private int eolWidth = 40;
    private int refHeaderWidth = 13;
    private int refWidth = 40;
    private int stackVarPrenameWidth = 10;
    private int stackVarNameWidth = 15;
    private int stackVarDataTypeWidth = 15;
    private int stackVarOffsetWidth = 8;
    private int stackVarCommentWidth = 20;
    private int stackVarXrefWidth = 50;
    private int dataFieldNameWidth = 12;
    private boolean showComments = true;
    private boolean showProperties = true;
    private boolean showStructures = true;
    private boolean showUndefinedData = true;
    private boolean showReferenceHeaders = true;
    private boolean showBackReferences = true;
    private boolean showForwardReferences = true;
    private boolean showFunctions = true;
    private boolean showBlockNameInOperands = true;
    private String labelSuffix = ":";
    private String commentPrefix = ";";

    ProgramTextOptions() {
    }

    List<Option> getOptions() {
        Option[] options = new Option[]{new Option(OPTION_WIDTH, OPTION_WIDTH_LABEL, new Integer(this.labelWidth)), new Option(OPTION_WIDTH, OPTION_WIDTH_ADDR, new Integer(this.addrWidth)), new Option(OPTION_WIDTH, OPTION_WIDTH_BYTES, new Integer(this.bytesWidth)), new Option(OPTION_WIDTH, OPTION_WIDTH_PREMNEMONIC, new Integer(this.preMnemonicWidth)), new Option(OPTION_WIDTH, OPTION_WIDTH_MNEMONIC, new Integer(this.mnemonicWidth)), new Option(OPTION_WIDTH, OPTION_WIDTH_OPERAND, new Integer(this.operandWidth)), new Option(OPTION_WIDTH, OPTION_WIDTH_EOL, new Integer(this.eolWidth)), new Option(OPTION_WIDTH, OPTION_WIDTH_REF, new Integer(this.refWidth)), new Option(OPTION_WIDTH, OPTION_WIDTH_DATA_FIELD, new Integer(this.dataFieldNameWidth)), new Option(OPTION_SHOW, OPTION_SHOW_COMMENTS, new Boolean(this.showComments)), new Option(OPTION_SHOW, OPTION_SHOW_PROPERTIES, new Boolean(this.showProperties)), new Option(OPTION_SHOW, OPTION_SHOW_STRUCTURES, new Boolean(this.showStructures)), new Option(OPTION_SHOW, OPTION_SHOW_UNDEFINED, new Boolean(this.showUndefinedData)), new Option(OPTION_SHOW, OPTION_SHOW_REF_HEADER, new Boolean(this.showReferenceHeaders)), new Option(OPTION_SHOW, OPTION_SHOW_BACK_REFS, new Boolean(this.showBackReferences)), new Option(OPTION_SHOW, OPTION_SHOW_FORWARD_REFS, new Boolean(this.showForwardReferences)), new Option(OPTION_SHOW, OPTION_SHOW_FUNCTIONS, new Boolean(this.showFunctions)), new Option(OPTION_SHOW, OPTION_SHOW_BLOCK_NAMES, new Boolean(this.showBlockNameInOperands)), new Option(OPTION_ADV, OPTION_ADV_LABEL_SUFFIX, this.labelSuffix), new Option(OPTION_ADV, OPTION_ADV_COMMENT_SUFFIX, this.commentPrefix)};
        ArrayList<Option> optionsList = new ArrayList<Option>();
        Collections.addAll(optionsList, options);
        return optionsList;
    }

    void setOptions(List<Option> options) throws OptionException {
        for (Option option : options) {
            boolean wasOptionHandled = true;
            String groupName = option.getGroup();
            String optionName = option.getName();
            try {
                int value;
                if (groupName.equals(OPTION_WIDTH)) {
                    value = (Integer)option.getValue();
                    if (optionName.equals(OPTION_WIDTH_LABEL)) {
                        this.labelWidth = value;
                    } else if (optionName.equals(OPTION_WIDTH_ADDR)) {
                        this.addrWidth = value;
                    } else if (optionName.equals(OPTION_WIDTH_BYTES)) {
                        this.bytesWidth = value;
                    } else if (optionName.equals(OPTION_WIDTH_PREMNEMONIC)) {
                        this.preMnemonicWidth = value;
                    } else if (optionName.equals(OPTION_WIDTH_MNEMONIC)) {
                        this.mnemonicWidth = value;
                    } else if (optionName.equals(OPTION_WIDTH_OPERAND)) {
                        this.operandWidth = value;
                    } else if (optionName.equals(OPTION_WIDTH_EOL)) {
                        this.eolWidth = value;
                    } else if (optionName.equals(OPTION_WIDTH_REF)) {
                        this.refWidth = value;
                    } else if (optionName.equals(OPTION_WIDTH_DATA_FIELD)) {
                        this.dataFieldNameWidth = value;
                    } else {
                        wasOptionHandled = false;
                    }
                } else if (groupName.equals(OPTION_SHOW)) {
                    value = ((Boolean)option.getValue()).booleanValue() ? 1 : 0;
                    if (optionName.equals(OPTION_SHOW_COMMENTS)) {
                        this.showComments = value;
                    } else if (optionName.equals(OPTION_SHOW_PROPERTIES)) {
                        this.showProperties = value;
                    } else if (optionName.equals(OPTION_SHOW_STRUCTURES)) {
                        this.showStructures = value;
                    } else if (optionName.equals(OPTION_SHOW_UNDEFINED)) {
                        this.showUndefinedData = value;
                    } else if (optionName.equals(OPTION_SHOW_REF_HEADER)) {
                        this.showReferenceHeaders = value;
                    } else if (optionName.equals(OPTION_SHOW_BACK_REFS)) {
                        this.showBackReferences = value;
                    } else if (optionName.equals(OPTION_SHOW_FORWARD_REFS)) {
                        this.showForwardReferences = value;
                    } else if (optionName.equals(OPTION_SHOW_FUNCTIONS)) {
                        this.showFunctions = value;
                    } else if (optionName.equals(OPTION_SHOW_BLOCK_NAMES)) {
                        this.showBlockNameInOperands = value;
                    } else {
                        wasOptionHandled = false;
                    }
                } else if (groupName.equals(OPTION_ADV)) {
                    String value2 = (String)option.getValue();
                    if (optionName.equals(OPTION_ADV_COMMENT_SUFFIX)) {
                        this.commentPrefix = value2;
                    } else if (optionName.equals(OPTION_ADV_LABEL_SUFFIX)) {
                        this.labelSuffix = value2;
                    } else {
                        wasOptionHandled = false;
                    }
                }
                if (!wasOptionHandled) {
                    throw new OptionException("Unknown option: " + optionName + " in group: " + groupName);
                }
                int len = this.addrWidth + this.bytesWidth + this.preMnemonicWidth + this.mnemonicWidth + this.operandWidth + this.eolWidth + this.dataFieldNameWidth + this.refWidth + this.labelWidth;
                if (len >= 1) continue;
                throw new OptionException("Need some width values.");
            }
            catch (ClassCastException e) {
                throw new OptionException("Invalid value for " + optionName + " - " + option.getValue());
            }
        }
    }

    void writeConfigState(SaveState saveState) {
        saveState.putInt("ADDR_WIDTH", this.getAddrWidth());
        saveState.putInt("BYTES_WIDTH", this.getBytesWidth());
        saveState.putInt("LABEL_WIDTH", this.getLabelWidth());
        saveState.putInt("PREMNEMONIC_WIDTH", this.getPreMnemonicWidth());
        saveState.putInt("MNEMONIC_WIDTH", this.getMnemonicWidth());
        saveState.putInt("OPERAND_WIDTH", this.getOperandWidth());
        saveState.putInt("EOL_WIDTH", this.getEolWidth());
        saveState.putInt("REF_WIDTH", this.getRefWidth());
        saveState.putInt("DATA_FIELD_NAME_WIDTH", this.getDataFieldNameWidth());
        saveState.putString("LABEL_SUFFIX", this.getLabelSuffix());
        saveState.putString("COMMENT_PREFIX", this.getCommentPrefix());
        saveState.putBoolean("INCLUDE_BLOCKNAMES", this.isShowBlockNameInOperands());
    }

    void readConfigState(SaveState saveState) {
        this.addrWidth = saveState.getInt("ADDR_WIDTH", 16);
        this.bytesWidth = saveState.getInt("BYTES_WIDTH", 12);
        this.labelWidth = saveState.getInt("LABEL_WIDTH", 30);
        this.preMnemonicWidth = saveState.getInt("PREMNEMONIC_WIDTH", 4);
        this.mnemonicWidth = saveState.getInt("MNEMONIC_WIDTH", 12);
        this.operandWidth = saveState.getInt("OPERAND_WIDTH", 40);
        this.eolWidth = saveState.getInt("EOL_WIDTH", 40);
        this.refWidth = saveState.getInt("REF_WIDTH", 40);
        this.dataFieldNameWidth = saveState.getInt("DATA_FIELD_NAME_WIDTH", 12);
        this.labelSuffix = saveState.getString("LABEL_SUFFIX", DEFAULT_LABEL_SUFFIX);
        this.commentPrefix = saveState.getString("COMMENT_PREFIX", DEFAULT_COMMENT_PREFIX);
        this.showBlockNameInOperands = saveState.getBoolean("INCLUDE_BLOCKNAMES", true);
    }

    int getAddrWidth() {
        return this.addrWidth;
    }

    int getBytesWidth() {
        return this.bytesWidth;
    }

    int getDataFieldNameWidth() {
        return this.dataFieldNameWidth;
    }

    int getEolWidth() {
        return this.eolWidth;
    }

    int getLabelWidth() {
        return this.labelWidth;
    }

    int getMnemonicWidth() {
        return this.mnemonicWidth;
    }

    int getOperandWidth() {
        return this.operandWidth;
    }

    int getPreMnemonicWidth() {
        return this.preMnemonicWidth;
    }

    int getRefHeaderWidth() {
        return this.refHeaderWidth;
    }

    int getRefWidth() {
        return this.refWidth;
    }

    boolean isShowBackReferences() {
        return this.showBackReferences;
    }

    boolean isShowComments() {
        return this.showComments;
    }

    boolean isShowBlockNameInOperands() {
        return this.showBlockNameInOperands;
    }

    boolean isShowForwardReferences() {
        return this.showForwardReferences;
    }

    boolean isShowFunctions() {
        return this.showFunctions;
    }

    boolean isShowProperties() {
        return this.showProperties;
    }

    boolean isShowReferenceHeaders() {
        return this.showReferenceHeaders;
    }

    boolean isShowStructures() {
        return this.showStructures;
    }

    boolean isShowUndefinedData() {
        return this.showUndefinedData;
    }

    int getStackVarCommentWidth() {
        return this.stackVarCommentWidth;
    }

    int getStackVarDataTypeWidth() {
        return this.stackVarDataTypeWidth;
    }

    int getStackVarNameWidth() {
        return this.stackVarNameWidth;
    }

    int getStackVarOffsetWidth() {
        return this.stackVarOffsetWidth;
    }

    int getStackVarPreNameWidth() {
        return this.stackVarPrenameWidth;
    }

    int getStackVarXrefWidth() {
        return this.stackVarXrefWidth;
    }

    String getCommentPrefix() {
        return this.commentPrefix;
    }

    String getLabelSuffix() {
        return this.labelSuffix;
    }

    boolean isHTML() {
        return this.isHTML;
    }

    void setHTML(boolean b) {
        this.isHTML = b;
    }

    boolean isShowFunctionLabel() {
        return false;
    }

    boolean isShowBlockName() {
        return this.showBlockNameInOperands;
    }
}

