/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import generic.jar.ResourceFile;
import ghidra.app.util.opinion.LibraryLookupTable;
import ghidra.util.Msg;
import ghidra.util.xml.XmlUtilities;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;

class LibraryHints {
    private static final String HINTS_EXT = ".hints";
    private HashMap<String, List<Attribute>> nameAttributeMap = new HashMap();
    private HashMap<Integer, List<Attribute>> ordinalAttributeMap = new HashMap();

    private LibraryHints() {
    }

    private void add(int ordinal, Attribute attr) {
        List<Attribute> list = this.ordinalAttributeMap.get(ordinal);
        if (list == null) {
            list = new ArrayList<Attribute>();
            this.ordinalAttributeMap.put(ordinal, list);
        }
        list.add(attr);
    }

    private void add(String name, Attribute attr) {
        List<Attribute> list = this.nameAttributeMap.get(name);
        if (list == null) {
            list = new ArrayList<Attribute>();
            this.nameAttributeMap.put(name, list);
        }
        list.add(attr);
    }

    private void loadMap(List<Attribute> list, HashMap<String, Attribute> map) {
        if (list != null) {
            for (Attribute attr : list) {
                map.put(attr.getName(), attr);
            }
        }
    }

    private Attribute getAttribute(List<Attribute> list, String attrName) {
        if (list != null) {
            for (Attribute attr : list) {
                if (!attrName.equals(attr.getName())) continue;
                return attr;
            }
        }
        return null;
    }

    Collection<Attribute> getAttributeHints(int ordinal, String name) {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>();
        this.loadMap(this.nameAttributeMap.get(name), map);
        this.loadMap(this.ordinalAttributeMap.get(ordinal), map);
        return map.values();
    }

    Attribute getAttributeHint(int ordinal, String name, String attrName) {
        Attribute attr;
        List<Attribute> list = this.ordinalAttributeMap.get(ordinal);
        if (list != null && (attr = this.getAttribute(list, attrName)) != null) {
            return attr;
        }
        list = this.nameAttributeMap.get(name);
        if (list != null && (attr = this.getAttribute(list, attrName)) != null) {
            return attr;
        }
        return null;
    }

    private static ResourceFile getHintsFile(String libraryName, int size) {
        String filename = libraryName.toUpperCase();
        return LibraryLookupTable.getExistingExtensionedFile(filename, HINTS_EXT, size);
    }

    static LibraryHints getLibraryHints(String libraryName, int size) {
        LibraryHints hints = new LibraryHints();
        ResourceFile file = LibraryHints.getHintsFile(libraryName, size);
        if (file != null && file.isFile()) {
            hints.readLibraryHints(file);
        }
        return hints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readLibraryHints(ResourceFile hintsFile) {
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(hintsFile.getInputStream());
            SAXBuilder sax = XmlUtilities.createSecureSAXBuilder((boolean)false, (boolean)false);
            Document document = sax.build((InputStream)is);
            Element root = document.getRootElement();
            if (!"LIBRARY_HINTS".equals(root.getName())) {
                throw new SAXNotRecognizedException("Expected LIBRARY_HINTS document");
            }
            for (Element element : root.getChildren()) {
                if ("HINT".equals(element.getName())) {
                    this.parseHint(element);
                    continue;
                }
                throw new SAXNotRecognizedException("Unexpected element: " + element.getName());
            }
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Error occured while parsing hints file: " + hintsFile), (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void parseHint(Element element) throws SAXException {
        String name;
        String attrName = element.getAttributeValue("ATTR");
        String value = element.getAttributeValue("VALUE");
        if (attrName == null) {
            throw new SAXException("HINT element requires both ATTR and VALUE attributes");
        }
        String ordStr = element.getAttributeValue("ORDINAL");
        if (ordStr != null) {
            try {
                this.add(Integer.parseInt(ordStr), new Attribute(attrName, value));
            }
            catch (NumberFormatException e) {
                throw new SAXException("HINT element ORDINAL attribute must be an integer value");
            }
        }
        if ((name = element.getAttributeValue("NAME")) != null) {
            this.add(name, new Attribute(attrName, value));
        }
    }
}

