/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.format;

import docking.action.DockingActionIf;
import docking.help.Help;
import docking.help.HelpService;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.indexedscrollpane.IndexedScrollPane;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.format.FieldHeaderComp;
import ghidra.app.util.viewer.format.FieldHeaderLocation;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.app.util.viewer.format.FormatModelListener;
import ghidra.app.util.viewer.format.actions.AddAllFieldAction;
import ghidra.app.util.viewer.format.actions.AddFieldAction;
import ghidra.app.util.viewer.format.actions.AddSpacerFieldAction;
import ghidra.app.util.viewer.format.actions.DisableFieldAction;
import ghidra.app.util.viewer.format.actions.EnableFieldAction;
import ghidra.app.util.viewer.format.actions.InsertRowAction;
import ghidra.app.util.viewer.format.actions.RemoveAllFieldsAction;
import ghidra.app.util.viewer.format.actions.RemoveFieldAction;
import ghidra.app.util.viewer.format.actions.RemoveRowAction;
import ghidra.app.util.viewer.format.actions.ResetAllFormatsAction;
import ghidra.app.util.viewer.format.actions.ResetFormatAction;
import ghidra.app.util.viewer.format.actions.SetSpacerTextAction;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FieldHeader
extends JTabbedPane
implements ChangeListener {
    private FormatManager formatManager;
    private FormatModelListener formatListener = new FormatModelListener(){

        @Override
        public void formatModelAdded(FieldFormatModel formatModel) {
            FieldHeader.this.createTabs();
        }

        @Override
        public void formatModelRemoved(FieldFormatModel formatModel) {
            FieldHeader.this.createTabs();
        }

        @Override
        public void formatModelChanged(FieldFormatModel formatModel) {
            FieldHeader.this.repaint();
        }
    };
    private boolean tabLock = false;
    private FieldFactory selectedFactory;
    private List<FieldHeaderComp> fieldHeaderComps = new ArrayList<FieldHeaderComp>();
    private IndexedScrollPane scroller;
    private JComponent centerComponent;
    private final FieldPanel fieldPanel;

    public FieldHeader(FormatManager formatMgr, IndexedScrollPane scroller, FieldPanel panel) {
        this.formatManager = formatMgr;
        this.scroller = scroller;
        this.fieldPanel = panel;
        this.createTabs();
        formatMgr.addFormatModelListener(this.formatListener);
        HelpService help = Help.getHelpService();
        help.registerHelp((Object)this, new HelpLocation("CodeBrowserPlugin", "Field_Formatter"));
        this.addChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent ev) {
        int index = this.getSelectedIndex();
        if (this.centerComponent == null || index < 0) {
            this.scroller.setColumnHeaderComp(null);
            return;
        }
        JPanel panel = (JPanel)this.getSelectedComponent();
        this.scroller.setColumnHeaderComp((JComponent)this.fieldHeaderComps.get(index));
        panel.removeAll();
        panel.add((Component)this.centerComponent, "Center");
        this.fieldPanel.requestFocus();
    }

    public List<DockingActionIf> getActions(String ownerName) {
        ArrayList<DockingActionIf> actionsList = new ArrayList<DockingActionIf>();
        actionsList.add((DockingActionIf)new DisableFieldAction(ownerName, this));
        actionsList.add((DockingActionIf)new EnableFieldAction(ownerName, this));
        actionsList.add((DockingActionIf)new InsertRowAction(ownerName, this));
        actionsList.add((DockingActionIf)new RemoveFieldAction(ownerName, this));
        actionsList.add((DockingActionIf)new RemoveRowAction(ownerName, this));
        actionsList.add((DockingActionIf)new ResetFormatAction(ownerName, this));
        actionsList.add((DockingActionIf)new ResetAllFormatsAction(ownerName, this.formatManager, this));
        actionsList.add((DockingActionIf)new AddAllFieldAction(ownerName, this));
        actionsList.add((DockingActionIf)new RemoveAllFieldsAction(ownerName, this));
        actionsList.add((DockingActionIf)new AddSpacerFieldAction(ownerName, this));
        actionsList.add((DockingActionIf)new SetSpacerTextAction(ownerName));
        int numModels = this.formatManager.getNumModels();
        for (int i = 0; i < numModels; ++i) {
            FieldFormatModel formatModel = this.formatManager.getModel(i);
            this.addLocalFieldActions(actionsList, ownerName, formatModel);
        }
        return new ArrayList<DockingActionIf>(actionsList);
    }

    private void addLocalFieldActions(List<DockingActionIf> actionList, String ownerName, FieldFormatModel formatModel) {
        FieldFactory[] allFactories;
        for (FieldFactory fieldFactory : allFactories = formatModel.getAllFactories()) {
            AddFieldAction addFieldAction = new AddFieldAction(ownerName, fieldFactory, this, formatModel);
            actionList.add((DockingActionIf)addFieldAction);
        }
    }

    private void createTabs() {
        this.fieldHeaderComps.clear();
        int selectedIndex = this.getSelectedIndex();
        this.removeAll();
        for (int i = 0; i < this.formatManager.getNumModels(); ++i) {
            FieldFormatModel formatModel = this.formatManager.getModel(i);
            FieldHeaderComp fieldHeaderComp = new FieldHeaderComp(this, i);
            this.fieldHeaderComps.add(fieldHeaderComp);
            JPanel tabPanel = new JPanel(new BorderLayout());
            this.addTab(formatModel.getName(), tabPanel);
        }
        if (selectedIndex >= 0 && selectedIndex < this.getTabCount()) {
            this.setSelectedIndex(selectedIndex);
        }
    }

    public FieldFormatModel getCurrentModel() {
        return this.formatManager.getModel(this.getSelectedIndex());
    }

    public void resetFormat() {
        this.formatManager.setDefaultFormat(this.getSelectedIndex());
    }

    public void setSelectedFieldFactory(FieldFactory factory) {
        if (!this.tabLock) {
            this.setSelectedIndex(this.indexOfTab(factory.getFieldModel().getName()));
            this.selectedFactory = factory;
        }
    }

    public FieldFactory getSelectedFieldFactory() {
        return this.selectedFactory;
    }

    public void resetAllFormats() {
        this.formatManager.setDefaultFormats();
    }

    public FieldHeaderLocation getFieldHeaderLocation(Point p) {
        return this.getHeaderTab().getFieldHeaderLocation(p);
    }

    public FieldHeaderComp getHeaderTab() {
        return this.fieldHeaderComps.get(this.getSelectedIndex());
    }

    public void setTabLock(boolean b) {
        this.tabLock = b;
    }

    public FormatManager getFormatManager() {
        return this.formatManager;
    }

    public void setViewComponent(JComponent centerComponent) {
        this.centerComponent = centerComponent;
        this.stateChanged(null);
    }
}

