/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.analysis.gui;

import docking.widgets.checkbox.GCheckBox;
import docking.widgets.label.GDLabel;
import ghidra.app.services.Analyzer;
import ghidra.app.services.AnalyzerType;
import ghidra.framework.analysis.AnalysisPhase;
import ghidra.framework.analysis.AnalysisRecipe;
import ghidra.framework.analysis.gui.AnalyzerUtil;
import ghidra.util.layout.MiddleLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import resources.ResourceManager;

public class AnalyzerPanel
extends JPanel {
    private static final Border RAISED_BUTTON_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0, Color.LIGHT_GRAY, Color.DARK_GRAY), BorderFactory.createEmptyBorder(1, 1, 1, 1));
    private static final Border LOWERED_BUTTON_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, Color.LIGHT_GRAY, Color.DARK_GRAY), BorderFactory.createEmptyBorder(1, 1, 1, 1));
    public static final Icon DELAYED_ICON = ResourceManager.loadImage((String)"images/ledyellow.png");
    public static final Icon DISABLED_ICON = ResourceManager.loadImage((String)"images/ledred.png");
    public static final Icon ENABLED_ICON = ResourceManager.loadImage((String)"images/ledgreen.png");
    private Analyzer analyzer;
    private AnalysisRecipe recipe;
    private JCheckBox enabledCheckbox;
    private JLabel analyzerNameLabel;
    private JLabel priorityLabel;
    private JLabel iconLabel;
    private JPanel phasePanel;
    private JLabel phaseLabel;
    private AnalysisPhase relevantPhase;

    public AnalyzerPanel(Analyzer analyzer, AnalysisRecipe recipe, AnalysisPhase relevantPhase) {
        super(new BorderLayout());
        this.analyzer = analyzer;
        this.recipe = recipe;
        this.relevantPhase = relevantPhase;
        this.add(this.buildInfoPanel(), "Center");
        this.add(this.buildPhasePanel(), "East");
        this.setBackground(Color.WHITE);
    }

    public int getPhasePanelWidth() {
        return this.phasePanel.getPreferredSize().width;
    }

    private Component buildInfoPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.add(this.buildCheckboxAndIconPanel(), "West");
        panel.add(this.buildLabelPanel(), "Center");
        return panel;
    }

    private Component buildCheckboxAndIconPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 10));
        this.enabledCheckbox = new GCheckBox();
        this.enabledCheckbox.addActionListener(e -> this.recipe.setAnalyzerEnablement(this.analyzer, this.enabledCheckbox.isSelected()));
        this.enabledCheckbox.setSelected(this.recipe.isAnalyzerEnabled(this.analyzer));
        panel.add((Component)this.enabledCheckbox, "West");
        this.iconLabel = new GDLabel();
        this.updateIconLabel();
        this.iconLabel.setBorder(BorderFactory.createEmptyBorder(2, 15, 2, 5));
        panel.add((Component)this.iconLabel, "East");
        return panel;
    }

    private Component buildLabelPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(4, 10, 2, 5));
        panel.setOpaque(false);
        this.analyzerNameLabel = new GDLabel(this.analyzer.getName());
        this.analyzerNameLabel.setFont(this.analyzerNameLabel.getFont().deriveFont(18.0f));
        panel.add((Component)this.analyzerNameLabel, "Center");
        this.priorityLabel = new GDLabel(this.analyzer.getPriority().toString());
        this.priorityLabel.setHorizontalAlignment(4);
        this.priorityLabel.setFont(this.priorityLabel.getFont().deriveFont(10.0f));
        this.priorityLabel.setForeground(Color.GRAY);
        panel.add((Component)this.priorityLabel, "South");
        return panel;
    }

    private void updateIconLabel() {
        AnalyzerType analyzerType = this.analyzer.getAnalysisType();
        this.iconLabel.setToolTipText(analyzerType.getDescription());
        this.iconLabel.setIcon(AnalyzerUtil.getIcon(analyzerType));
    }

    private Component buildPhasePanel() {
        this.phasePanel = new JPanel((LayoutManager)new MiddleLayout());
        Border empty = BorderFactory.createEmptyBorder(0, 20, 0, 20);
        Border etched = BorderFactory.createEtchedBorder();
        this.phasePanel.setBorder(BorderFactory.createCompoundBorder(etched, empty));
        this.phasePanel.setOpaque(false);
        this.phasePanel.setPreferredSize(new Dimension(60, 0));
        this.phaseLabel = new GDLabel("");
        String text = this.analyzer.getAnalysisType() == AnalyzerType.ONE_SHOT_ANALYZER ? "Phase when this analyzer runs. (Select and press number to change)" : "Phase when this analyzer first becomes active. (Select and press number to change)";
        this.phaseLabel.setToolTipText(text);
        this.phasePanel.setToolTipText(text);
        this.updatePhaseLabel();
        this.phasePanel.add(this.phaseLabel);
        return this.phasePanel;
    }

    public void setAnalyzer(Analyzer analyzer) {
        if (this.analyzer != analyzer) {
            this.analyzer = analyzer;
            this.updateInfoFields();
        }
        this.updateAnalyzerStatus();
        this.updateLabelColor();
    }

    private void updateLabelColor() {
        boolean enabled = this.recipe.isAnalyzerEnabled(this.analyzer);
        Color foreground = Color.BLACK;
        if (!enabled) {
            foreground = Color.LIGHT_GRAY;
        } else if (this.relevantPhase != null && this.recipe.getAnalyzerStartPhase(this.analyzer) == this.relevantPhase) {
            foreground = Color.blue;
        }
        this.analyzerNameLabel.setForeground(foreground);
        this.phaseLabel.setForeground(foreground);
    }

    private void updateAnalyzerStatus() {
        int nPanels;
        boolean enabled = this.recipe.isAnalyzerEnabled(this.analyzer);
        this.enabledCheckbox.setSelected(enabled);
        List<AnalysisPhase> analysisPhases = this.recipe.getAnalysisPhases();
        int nPhases = analysisPhases.size();
        for (int i = nPanels = this.phasePanel.getComponentCount(); i > nPhases; --i) {
            this.phasePanel.remove(i - 1);
        }
        this.updatePhaseLabel();
    }

    private void updatePhaseLabel() {
        if (this.recipe.isAnalyzerEnabled(this.analyzer)) {
            this.phaseLabel.setText(this.recipe.getAnalyzerStartPhase(this.analyzer).toString());
        } else {
            this.phaseLabel.setText("");
        }
    }

    private void updateInfoFields() {
        this.analyzerNameLabel.setText(this.analyzer.getName());
        this.priorityLabel.setText(this.analyzer.getPriority().toString());
        this.updateIconLabel();
    }

    public void setSelected(boolean b) {
        this.setBackground(b ? Color.YELLOW : Color.WHITE);
        this.repaint();
    }
}

