/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.field;

import ghidra.app.util.viewer.field.BrowserCodeUnitFormat;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.CodeUnitFormat;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.table.CodeUnitTableCellRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.table.field.CodeUnitCountSettingsDefinition;
import ghidra.util.table.field.CodeUnitOffsetSettingsDefinition;
import ghidra.util.table.field.CodeUnitTableCellData;
import ghidra.util.table.field.ProgramLocationTableColumnExtensionPoint;

public class CodeUnitTableColumn
extends ProgramLocationTableColumnExtensionPoint<ProgramLocation, CodeUnitTableCellData> {
    private static final CodeUnitCountSettingsDefinition CODE_UNIT_COUNT = CodeUnitCountSettingsDefinition.DEF;
    private static final CodeUnitOffsetSettingsDefinition CODE_UNIT_OFFSET = CodeUnitOffsetSettingsDefinition.DEF;
    private static SettingsDefinition[] SETTINGS_DEFS = new SettingsDefinition[]{CODE_UNIT_COUNT, CODE_UNIT_OFFSET};
    private BrowserCodeUnitFormat codeUnitFormat;
    private CodeUnitTableCellRenderer renderer = new CodeUnitTableCellRenderer();

    public String getColumnName() {
        return "Code Unit";
    }

    public String getColumnDisplayName(Settings settings) {
        String offset;
        Object name = this.getColumnName();
        int previewCnt = CODE_UNIT_COUNT.getCount(settings);
        if (previewCnt != 1) {
            name = (String)name + "[" + previewCnt + "]";
        }
        if (!"0".equals(offset = CODE_UNIT_OFFSET.getDisplayValue(settings))) {
            name = (String)name + offset;
        }
        return name;
    }

    public CodeUnitTableCellData getValue(ProgramLocation rowObject, Settings settings, Program data, ServiceProvider serviceProvider) throws IllegalArgumentException {
        ProgramLocation loc = rowObject;
        return new CodeUnitTableCellData(loc, this.getCodeUnitFormat(serviceProvider), CODE_UNIT_OFFSET.getOffset(settings), CODE_UNIT_COUNT.getCount(settings));
    }

    private CodeUnitFormat getCodeUnitFormat(ServiceProvider serviceProvider) {
        if (this.codeUnitFormat == null) {
            this.codeUnitFormat = new BrowserCodeUnitFormat(serviceProvider);
        }
        return this.codeUnitFormat;
    }

    @Override
    public ProgramLocation getProgramLocation(ProgramLocation rowObject, Settings settings, Program program, ServiceProvider serviceProvider) {
        return rowObject;
    }

    public GColumnRenderer<CodeUnitTableCellData> getColumnRenderer() {
        return this.renderer;
    }

    public SettingsDefinition[] getSettingsDefinitions() {
        return SETTINGS_DEFS;
    }

    public int getMaxLines(Settings settings) {
        return CODE_UNIT_COUNT.getCount(settings);
    }
}

