/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh;

import ghidra.app.plugin.processors.sleigh.ContextChange;
import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighDebugLogger;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.symbol.TripleSymbol;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public class ContextCommit
implements ContextChange {
    private TripleSymbol sym = null;
    private int num;
    private int mask;

    @Override
    public void apply(ParserWalker walker, SleighDebugLogger debug) throws MemoryAccessException {
        walker.getParserContext().addCommit(walker.getState(), this.sym, this.num, this.mask);
        if (debug != null) {
            debug.dumpGlobalSet(walker.getParserContext(), walker.getState(), this.sym, this.num, this.mask, walker.getParserContext().getContextBytes()[this.num] & this.mask);
        }
    }

    @Override
    public void restoreXml(XmlPullParser parser, SleighLanguage lang) {
        XmlElement el = parser.start(new String[]{"commit"});
        int id = SpecXmlUtils.decodeInt((String)el.getAttribute("id"));
        this.sym = (TripleSymbol)lang.getSymbolTable().findSymbol(id);
        this.num = SpecXmlUtils.decodeInt((String)el.getAttribute("num"));
        this.mask = SpecXmlUtils.decodeInt((String)el.getAttribute("mask"));
        parser.end(el);
    }
}

