/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.memstate;

import generic.stl.IteratorSTL;
import generic.stl.Pair;
import ghidra.pcode.memstate.MemoryBank;
import ghidra.pcode.memstate.MemoryFaultHandler;
import ghidra.pcode.memstate.MemoryPage;
import ghidra.pcode.memstate.MemoryPageBank;
import ghidra.program.model.address.AddressSpace;

public class MemoryPageOverlay
extends MemoryPageBank {
    protected MemoryBank underlie;

    public MemoryPageOverlay(AddressSpace spc, MemoryBank ul, MemoryFaultHandler faultHandler) {
        super(spc, ul.isBigEndian(), ul.getPageSize(), faultHandler);
        this.underlie = ul;
    }

    @Override
    protected MemoryPage getPage(long addr) {
        IteratorSTL iter = this.page.find((Object)addr);
        if (iter.equals(this.page.end())) {
            if (this.underlie == null) {
                int size = this.getPageSize();
                MemoryPage pageptr = new MemoryPage(size);
                for (int i = 0; i < size; ++i) {
                    pageptr.data[i] = 0;
                }
                pageptr.setUninitialized();
                return pageptr;
            }
            MemoryPage pageptr = this.underlie.getPage(addr);
            this.page.add((Object)addr, (Object)pageptr);
            return pageptr;
        }
        return (MemoryPage)((Pair)iter.get()).second;
    }
}

