/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.TypeDef;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;

class BitFieldDBDataType
extends BitFieldDataType {
    private static final int BIT_OFFSET_SHIFT = 8;
    private static final int BASE_TYPE_SHIFT = 16;
    private static final int DATATYPE_INDEX_SHIFT = 24;
    public static final long MAX_DATATYPE_INDEX = 0xFFFFFFFFL;
    private static final long ID_TO_INDEX_MASK = 0xFFFFFFFFFFFFFFL;

    BitFieldDBDataType(DataType baseDataType, int bitSize, int bitOffset) throws InvalidDataTypeException {
        super(baseDataType, bitSize, bitOffset);
    }

    static final long getId(BitFieldDataType bitfieldDt) {
        DataTypeManager dtm = bitfieldDt.getDataTypeManager();
        if (!(dtm instanceof DataTypeManagerDB)) {
            throw new AssertException("bitfieldDt must first be resolved");
        }
        BaseDatatypeKind dataTypeKind = BaseDatatypeKind.NONE;
        long dataTypeIndex = 0L;
        DataType baseDataType = bitfieldDt.getBaseDataType();
        if (baseDataType instanceof TypeDef) {
            dataTypeKind = BaseDatatypeKind.TYPEDEF;
        } else if (baseDataType instanceof Enum) {
            dataTypeKind = BaseDatatypeKind.ENUM;
        } else if (baseDataType instanceof AbstractIntegerDataType) {
            dataTypeKind = BaseDatatypeKind.INTEGER;
        }
        if (dataTypeKind != BaseDatatypeKind.NONE) {
            dataTypeIndex = BitFieldDBDataType.getResolvedDataTypeIndex(baseDataType, (DataTypeManagerDB)dtm);
            if (dataTypeIndex == -1L) {
                Msg.debug(BitFieldDBDataType.class, (Object)("Bit-Field data type not resolved: " + baseDataType.getName()));
                dataTypeIndex = 0xFFFFFFFFL;
                dataTypeKind = BaseDatatypeKind.NONE;
            } else if (dataTypeIndex >= 0xFFFFFFFFL) {
                Msg.debug(BitFieldDBDataType.class, (Object)("Bit-Field data type index out of range: " + baseDataType.getName()));
                dataTypeIndex = 0xFFFFFFFFL;
                dataTypeKind = BaseDatatypeKind.NONE;
            }
        }
        long id = dataTypeIndex << 24 | BitFieldDBDataType.getBaseTypeEncodedField(bitfieldDt, dataTypeKind) << 16 | (long)(bitfieldDt.getBitOffset() << 8) | (long)bitfieldDt.getDeclaredBitSize();
        return id;
    }

    private static final long getBaseTypeEncodedField(BitFieldDataType bitFieldDt, BaseDatatypeKind dataTypeKind) {
        int nominalStorageSize = BitFieldDataType.getMinimumStorageSize(bitFieldDt.getBitSize());
        boolean extraStorageUsed = bitFieldDt.getStorageSize() > nominalStorageSize;
        return (long)(dataTypeKind.id << 5) | (extraStorageUsed ? 16L : 0L);
    }

    static final BitFieldDataType getBitFieldDataType(long id, DataTypeManagerDB dtm) {
        int bitSize = (int)(id & 0xFFL);
        int bitOffset = (int)(id >> 8 & 0xFFL);
        int baseTypeInfo = (int)(id >> 16 & 0xFFL);
        BaseDatatypeKind baseDataTypeKind = BaseDatatypeKind.getKind(baseTypeInfo >> 5 & 3);
        DataType baseDataType = null;
        long dataTypeIndex = id >> 24 & 0xFFFFFFFFL;
        if (baseDataTypeKind != BaseDatatypeKind.NONE && dataTypeIndex != 0xFFFFFFFFL) {
            baseDataType = baseDataTypeKind == BaseDatatypeKind.TYPEDEF ? BitFieldDBDataType.getTypeDef(dataTypeIndex, dtm) : (baseDataTypeKind == BaseDatatypeKind.ENUM ? BitFieldDBDataType.getEnum(dataTypeIndex, dtm) : BitFieldDBDataType.getIntegerType(dataTypeIndex, dtm));
        }
        try {
            if (baseDataType == null) {
                baseDataType = IntegerDataType.dataType.clone(dtm);
            }
            return new BitFieldDBDataType(baseDataType, bitSize, bitOffset);
        }
        catch (InvalidDataTypeException e) {
            return null;
        }
    }

    private static final long getResolvedDataTypeIndex(DataType dataType, DataTypeManagerDB dtm) {
        long dataTypeId = dtm.getID(dataType);
        if (dataTypeId == -1L) {
            return -1L;
        }
        return dataTypeId & 0xFFFFFFFFFFFFFFL;
    }

    private static final TypeDef getTypeDef(long typeDefIndex, DataTypeManager dtm) {
        long dataTypeId = 0x500000000000000L | typeDefIndex;
        DataType dataType = dtm.getDataType(dataTypeId);
        if (!(dataType instanceof TypeDef)) {
            return null;
        }
        TypeDef typeDefDt = (TypeDef)dataType;
        DataType dt = typeDefDt.getBaseDataType();
        if (dt instanceof Enum) {
            return typeDefDt;
        }
        if (dt instanceof AbstractIntegerDataType) {
            return typeDefDt;
        }
        return null;
    }

    private static final Enum getEnum(long enumIndex, DataTypeManager dtm) {
        long dataTypeId = 0x800000000000000L | enumIndex;
        DataType dataType = dtm.getDataType(dataTypeId);
        if (!(dataType instanceof Enum)) {
            return null;
        }
        return (Enum)dataType;
    }

    private static final AbstractIntegerDataType getIntegerType(long intTypeIndex, DataTypeManager dtm) {
        long dataTypeId = 0L | intTypeIndex;
        DataType dataType = dtm.getDataType(dataTypeId);
        if (!(dataType instanceof AbstractIntegerDataType)) {
            return null;
        }
        return (AbstractIntegerDataType)dataType;
    }

    private static enum BaseDatatypeKind {
        NONE(0),
        TYPEDEF(1),
        ENUM(2),
        INTEGER(3);

        final int id;

        private BaseDatatypeKind(int id) {
            this.id = id;
        }

        static BaseDatatypeKind getKind(int value) {
            for (BaseDatatypeKind kind : BaseDatatypeKind.values()) {
                if (kind.id != value) continue;
                return kind;
            }
            return NONE;
        }
    }
}

