/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.oldfunction;

import db.DBHandle;
import db.Record;
import db.RecordIterator;
import db.Schema;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.oldfunction.OldFunctionDBAdapterV0;
import ghidra.program.database.oldfunction.OldFunctionDBAdapterV1;
import ghidra.util.exception.VersionException;
import java.io.IOException;

abstract class OldFunctionDBAdapter {
    static final int RETURN_DATA_TYPE_ID_COL = 0;
    static final int STACK_DEPTH_COL = 1;
    static final int STACK_PARAM_OFFSET_COL = 2;
    static final int STACK_RETURN_OFFSET_COL = 3;
    static final int STACK_LOCAL_SIZE_COL = 4;
    static final int REPEATABLE_COMMENT_COL = 5;
    static final Schema FUNCTIONS_SCHEMA = OldFunctionDBAdapterV1.V1_FUNCTIONS_SCHEMA;
    protected AddressMap addrMap;

    static OldFunctionDBAdapter getAdapter(DBHandle handle, AddressMap map) throws VersionException {
        try {
            return new OldFunctionDBAdapterV1(handle, map);
        }
        catch (VersionException e) {
            if (!e.isUpgradable()) {
                throw e;
            }
            return new OldFunctionDBAdapterV0(handle, map);
        }
    }

    OldFunctionDBAdapter(AddressMap map) {
        this.addrMap = map;
    }

    protected abstract void deleteTable(DBHandle var1) throws IOException;

    abstract int getRecordCount();

    abstract Record getFunctionRecord(long var1) throws IOException;

    abstract RecordIterator iterateFunctionRecords() throws IOException;
}

