/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.database.symbol.CodeSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.DataTypeSymbol;
import ghidra.program.model.pcode.DynamicSymbol;
import ghidra.program.model.pcode.FunctionPrototype;
import ghidra.program.model.pcode.HighConstant;
import ghidra.program.model.pcode.HighFunctionDBUtil;
import ghidra.program.model.pcode.HighGlobal;
import ghidra.program.model.pcode.HighLocal;
import ghidra.program.model.pcode.HighOther;
import ghidra.program.model.pcode.HighParam;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.JumpTable;
import ghidra.program.model.pcode.LocalSymbolMap;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import ghidra.program.model.pcode.PcodeException;
import ghidra.program.model.pcode.PcodeSyntaxTree;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.pcode.VarnodeAST;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import ghidra.xml.XmlPullParserFactory;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class HighFunction
extends PcodeSyntaxTree {
    public static final String DECOMPILER_TAG_MAP = "decompiler_tags";
    private Function func;
    private Language language;
    private CompilerSpec compilerSpec;
    private FunctionPrototype proto;
    private LocalSymbolMap localSymbols;
    private List<JumpTable> jumpTables;
    private List<DataTypeSymbol> protoOverrides;
    private boolean showNamespace = true;

    public HighFunction(Function function, Language language, CompilerSpec compilerSpec, PcodeDataTypeManager dtManager, boolean showNamespace) {
        super(function.getProgram().getAddressFactory(), dtManager);
        this.func = function;
        this.language = language;
        this.compilerSpec = compilerSpec;
        this.showNamespace = showNamespace;
        this.localSymbols = new LocalSymbolMap(this, "stack");
        this.proto = new FunctionPrototype(this.localSymbols, function);
        this.jumpTables = null;
        this.protoOverrides = null;
    }

    public Function getFunction() {
        return this.func;
    }

    public Language getLanguage() {
        return this.language;
    }

    public CompilerSpec getCompilerSpec() {
        return this.compilerSpec;
    }

    public FunctionPrototype getFunctionPrototype() {
        return this.proto;
    }

    public JumpTable[] getJumpTables() {
        if (this.jumpTables == null) {
            return new JumpTable[0];
        }
        JumpTable[] res = new JumpTable[this.jumpTables.size()];
        return this.jumpTables.toArray(res);
    }

    public LocalSymbolMap getLocalSymbolMap() {
        return this.localSymbols;
    }

    public HighSymbol getMappedSymbol(Address addr, Address pcaddr) {
        return this.localSymbols.findLocal(addr, pcaddr);
    }

    @Override
    public HighSymbol getSymbol(int symbolId) {
        return this.localSymbols.getSymbol(symbolId);
    }

    public void grabFromFunction(int overrideExtrapop, boolean includeDefaultNames, boolean doOverride) {
        this.localSymbols.grabFromFunction(includeDefaultNames);
        this.proto.grabFromFunction(this.func, overrideExtrapop, doOverride);
        this.jumpTables = null;
        this.protoOverrides = null;
        this.grabOverrides();
    }

    private void grabOverrides() {
        SymbolTable symtab = this.func.getProgram().getSymbolTable();
        Namespace space = HighFunction.findOverrideSpace(this.func);
        if (space == null) {
            return;
        }
        SymbolIterator iter = symtab.getSymbols(space);
        while (iter.hasNext()) {
            DataTypeSymbol protover;
            Symbol sym = iter.next();
            String nm = sym.getName();
            if (nm.length() < 3) continue;
            if ((nm = nm.substring(0, 3)).equals("jmp")) {
                JumpTable jumpTab;
                Object obj = sym.getObject();
                if (!(obj instanceof Namespace) || (jumpTab = JumpTable.readOverride((Namespace)obj, symtab)) == null) continue;
                if (this.jumpTables == null) {
                    this.jumpTables = new ArrayList<JumpTable>();
                }
                this.jumpTables.add(jumpTab);
                continue;
            }
            if (!nm.equals("prt") || sym.getSymbolType() != SymbolType.LABEL || (protover = HighFunctionDBUtil.readOverride(sym)) == null) continue;
            if (this.protoOverrides == null) {
                this.protoOverrides = new ArrayList<DataTypeSymbol>();
            }
            this.protoOverrides.add(protover);
        }
    }

    @Override
    public Varnode newVarnode(int sz, Address addr) {
        addr = this.func.getEntryPoint().getAddressSpace().getOverlayAddress(addr);
        return super.newVarnode(sz, addr);
    }

    @Override
    public Varnode newVarnode(int sz, Address addr, int id) {
        addr = this.func.getEntryPoint().getAddressSpace().getOverlayAddress(addr);
        return super.newVarnode(sz, addr, id);
    }

    private void readHighXML(XmlPullParser parser) throws PcodeXMLException {
        XmlElement el = parser.start(new String[]{"high"});
        String classstring = el.getAttribute("class");
        int symref = SpecXmlUtils.decodeInt((String)el.getAttribute("symref"));
        int repref = SpecXmlUtils.decodeInt((String)el.getAttribute("repref"));
        Varnode rep = this.getRef(repref);
        if (rep == null) {
            throw new PcodeXMLException("Undefined varnode reference");
        }
        DataType type = null;
        ArrayList<Varnode> vnlist = new ArrayList<Varnode>();
        int sz = -1;
        if (parser.peek().isStart()) {
            type = this.getDataTypeManager().readXMLDataType(parser);
        }
        if (type == null) {
            throw new PcodeXMLException("Missing <type> for HighVariable");
        }
        sz = type.getLength();
        while (parser.peek().isStart()) {
            Varnode vn = Varnode.readXML(parser, this);
            vnlist.add(vn);
        }
        Varnode[] vnarray = new Varnode[vnlist.size()];
        vnlist.toArray(vnarray);
        this.newHigh(symref, type, sz, vnarray, rep, classstring);
        parser.end(el);
    }

    private void readHighlistXML(XmlPullParser parser) throws PcodeXMLException {
        XmlElement el = parser.start(new String[]{"highlist"});
        while (parser.peek().isStart()) {
            this.readHighXML(parser);
        }
        parser.end(el);
    }

    @Override
    public void readXML(XmlPullParser parser) throws PcodeXMLException {
        XmlElement start = parser.start(new String[]{"function"});
        String name = start.getAttribute("name");
        if (!this.func.getName(this.showNamespace).equals(name)) {
            throw new PcodeXMLException("Function name mismatch: " + this.func.getName(this.showNamespace) + " + " + name);
        }
        while (!parser.peek().isEnd()) {
            XmlElement subel = parser.peek();
            if (subel.getName().equals("addr")) {
                subel = parser.start(new String[]{"addr"});
                Address addr = Varnode.readXMLAddress(subel, this.getAddressFactory());
                parser.end(subel);
                addr = this.func.getEntryPoint().getAddressSpace().getOverlayAddress(addr);
                if (this.func.getEntryPoint().equals(addr)) continue;
                throw new PcodeXMLException("Mismatched address in function tag");
            }
            if (subel.getName().equals("prototype")) {
                this.proto.readPrototypeXML(parser, this.getDataTypeManager());
                continue;
            }
            if (subel.getName().equals("localdb")) {
                this.localSymbols.parseScopeXML(parser);
                continue;
            }
            if (subel.getName().equals("ast")) {
                super.readXML(parser);
                continue;
            }
            if (subel.getName().equals("highlist")) {
                this.readHighlistXML(parser);
                continue;
            }
            if (subel.getName().equals("jumptablelist")) {
                this.readJumpTableListXML(parser);
                continue;
            }
            if (subel.getName().equals("override")) {
                parser.discardSubTree();
                continue;
            }
            if (subel.getName().equals("scope")) {
                parser.discardSubTree();
                continue;
            }
            throw new PcodeXMLException("Unknown tag in function: " + subel.getName());
        }
        parser.end(start);
    }

    private void readJumpTableListXML(XmlPullParser parser) throws PcodeXMLException {
        XmlElement el = parser.start(new String[]{"jumptablelist"});
        while (parser.peek().isStart()) {
            JumpTable table = new JumpTable(this.func.getEntryPoint().getAddressSpace());
            table.restoreXml(parser, this.getAddressFactory());
            if (table.isEmpty()) continue;
            if (this.jumpTables == null) {
                this.jumpTables = new ArrayList<JumpTable>();
            }
            this.jumpTables.add(table);
        }
        parser.end(el);
    }

    private HighVariable newHigh(int symref, DataType tp, int sz, Varnode[] inst, Varnode rep, String classstring) throws PcodeXMLException {
        try {
            HighSymbol sym;
            HighVariable var = null;
            if (classstring.equals("local")) {
                sym = null;
                if (symref != 0) {
                    sym = this.localSymbols.getSymbol(symref);
                }
                if (sym != null) {
                    var = sym.getHighVariable();
                }
                if (var == null) {
                    if (sym instanceof DynamicSymbol) {
                        var = new HighLocal(tp, rep, inst, sym.getPCAddress(), sym);
                        sym.setHighVariable(var);
                    } else {
                        var = new HighOther(tp, rep, inst, this.getPCAddress(rep), this);
                    }
                }
            } else if (classstring.equals("constant")) {
                sym = null;
                if (symref != 0 && (sym = this.localSymbols.getSymbol(symref)) != null) {
                    var = sym.getHighVariable();
                }
                if (var == null) {
                    if (sym instanceof DynamicSymbol) {
                        var = new HighConstant(sym.getName(), tp, rep, this.getPCAddress(rep), (DynamicSymbol)sym);
                        sym.setHighVariable(var);
                    } else {
                        var = new HighConstant(null, tp, rep, this.getPCAddress(rep), this);
                    }
                }
            } else if (classstring.equals("global")) {
                var = new HighGlobal(null, tp, rep, inst, this);
            } else if (classstring.equals("other")) {
                var = new HighOther(tp, rep, inst, this.getPCAddress(rep), this);
            } else {
                throw new PcodeXMLException("Bad class string: " + classstring);
            }
            if (rep.getSize() == var.getSize()) {
                var.attachInstances(inst, rep);
            } else {
                for (Varnode element : inst) {
                    ((VarnodeAST)element).setHigh(var);
                }
            }
            var.setHighOnInstances();
            return var;
        }
        catch (InvalidInputException e) {
            throw new PcodeXMLException("Bad storage node", e);
        }
    }

    private Address getPCAddress(Varnode rep) {
        Address pcaddr = null;
        if (!rep.isAddrTied() && (pcaddr = rep.getPCAddress()) == Address.NO_ADDRESS) {
            try {
                pcaddr = this.func.getEntryPoint().add(-1L);
            }
            catch (AddressOutOfBoundsException e) {
                pcaddr = this.func.getEntryPoint();
            }
        }
        return pcaddr;
    }

    public HighVariable splitOutMergeGroup(HighVariable high, Varnode vn) throws PcodeException {
        try {
            HighVariable resremain;
            HighLocal reslocal;
            HighSymbol sym;
            Varnode[] curinst;
            ArrayList<Varnode> newinst = new ArrayList<Varnode>();
            ArrayList<Varnode> oldinst = new ArrayList<Varnode>();
            short ourgroup = vn.getMergeGroup();
            for (Varnode curvn : curinst = high.getInstances()) {
                if (curvn.getMergeGroup() == ourgroup) {
                    newinst.add(curvn);
                    continue;
                }
                oldinst.add(curvn);
            }
            if (oldinst.size() == 0) {
                return high;
            }
            if (!(high instanceof HighLocal)) {
                throw new PcodeException("Variable " + high.getName() + " is speculatively merged but not a local");
            }
            HighLocal highloc = (HighLocal)high;
            Varnode[] newinstarray = new Varnode[newinst.size()];
            newinst.toArray(newinstarray);
            Varnode[] oldinstarray = new Varnode[oldinst.size()];
            oldinst.toArray(oldinstarray);
            Varnode oldrep = high.getRepresentative();
            if (oldrep.getMergeGroup() == ourgroup) {
                if (high instanceof HighParam) {
                    return high;
                }
                vn = oldrep;
                oldrep = oldinstarray[0];
                sym = highloc.getSymbol();
                reslocal = new HighLocal(highloc.getDataType(), highloc.getRepresentative(), null, highloc.getPCAddress(), sym);
                resremain = new HighOther(highloc.getDataType(), new Varnode(oldrep.getAddress(), highloc.getSize()), null, oldrep.getPCAddress(), this);
            } else {
                sym = this.localSymbols.newMappedSymbol(highloc.getName(), highloc.getDataType(), new VariableStorage(this.func.getProgram(), vn), vn.getPCAddress(), -1, vn.hashCode());
                reslocal = new HighLocal(highloc.getDataType(), vn, null, vn.getPCAddress(), sym);
                resremain = highloc;
            }
            sym.setHighVariable(reslocal);
            reslocal.attachInstances(newinstarray, vn);
            for (Varnode element : newinstarray) {
                ((VarnodeAST)element).setHigh(reslocal);
            }
            resremain.attachInstances(oldinstarray, oldrep);
            for (Varnode element : oldinstarray) {
                ((VarnodeAST)element).setHigh(resremain);
            }
            return reslocal;
        }
        catch (InvalidInputException e) {
            throw new PcodeXMLException("Bad storage node", e);
        }
    }

    public String buildFunctionXML(Address entryPoint, int size) {
        boolean hasOverrideTag;
        StringBuilder resBuf = new StringBuilder();
        resBuf.append("<function");
        SpecXmlUtils.xmlEscapeAttribute((StringBuilder)resBuf, (String)"name", (String)this.func.getName(this.showNamespace));
        SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"size", (long)size);
        if (this.func.isInline()) {
            SpecXmlUtils.encodeBooleanAttribute((StringBuilder)resBuf, (String)"inline", (boolean)true);
        }
        if (this.func.hasNoReturn()) {
            SpecXmlUtils.encodeBooleanAttribute((StringBuilder)resBuf, (String)"noreturn", (boolean)true);
        }
        resBuf.append(">\n");
        if (entryPoint == null) {
            resBuf.append(Varnode.buildXMLAddress(this.func.getEntryPoint()));
        } else {
            resBuf.append(Varnode.buildXMLAddress(entryPoint));
        }
        resBuf.append(this.localSymbols.buildLocalDbXML());
        this.proto.buildPrototypeXML(resBuf, this.getDataTypeManager());
        if (this.jumpTables != null && this.jumpTables.size() > 0) {
            resBuf.append("<jumptablelist>\n");
            for (int i = 0; i < this.jumpTables.size(); ++i) {
                this.jumpTables.get(i).buildXml(resBuf);
            }
            resBuf.append("</jumptablelist>\n");
        }
        boolean bl = hasOverrideTag = this.protoOverrides != null && this.protoOverrides.size() > 0;
        if (hasOverrideTag) {
            resBuf.append("<override>\n");
        }
        if (this.protoOverrides != null && this.protoOverrides.size() > 0) {
            PcodeDataTypeManager dtmanage = this.getDataTypeManager();
            for (int i = 0; i < this.protoOverrides.size(); ++i) {
                DataTypeSymbol sym = this.protoOverrides.get(i);
                Address addr = sym.getAddress();
                FunctionPrototype fproto = new FunctionPrototype((FunctionSignature)((Object)sym.getDataType()), this.compilerSpec, false);
                resBuf.append("<protooverride>\n");
                resBuf.append("<addr");
                Varnode.appendSpaceOffset(resBuf, addr);
                resBuf.append("/>\n");
                fproto.buildPrototypeXML(resBuf, dtmanage);
                resBuf.append("</protooverride>\n");
            }
        }
        if (hasOverrideTag) {
            resBuf.append("</override>\n");
        }
        resBuf.append("</function>\n");
        return resBuf.toString();
    }

    public static String buildFunctionShellXML(String name, Address addr) {
        StringBuilder resBuf = new StringBuilder();
        resBuf.append("<function");
        SpecXmlUtils.xmlEscapeAttribute((StringBuilder)resBuf, (String)"name", (String)name);
        SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"size", (long)1L);
        resBuf.append(">\n");
        resBuf.append(Varnode.buildXMLAddress(addr));
        resBuf.append("</function>\n");
        return resBuf.toString();
    }

    public static ErrorHandler getErrorHandler(final Object errOriginator, final String targetName) {
        return new ErrorHandler(){

            @Override
            public void error(SAXParseException exception) throws SAXException {
                Msg.error((Object)errOriginator, (Object)("Error parsing " + targetName), (Throwable)exception);
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                Msg.error((Object)errOriginator, (Object)("Fatal error parsing " + targetName), (Throwable)exception);
            }

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                Msg.warn((Object)errOriginator, (Object)("Warning parsing " + targetName), (Throwable)exception);
            }
        };
    }

    public static Namespace findOverrideSpace(Function func) {
        SymbolTable symtab = func.getProgram().getSymbolTable();
        return HighFunction.findNamespace(symtab, func, "override");
    }

    public static Namespace findCreateOverrideSpace(Function func) {
        SymbolTable symtab = func.getProgram().getSymbolTable();
        return HighFunction.findCreateNamespace(symtab, func, "override");
    }

    public static Namespace findNamespace(SymbolTable symtab, Namespace parent, String name) {
        return symtab.getNamespace(name, parent);
    }

    public static void createLabelSymbol(SymbolTable symtab, Address addr, String name, Namespace namespace, SourceType source, boolean useLocalNamespace) throws InvalidInputException {
        if (namespace == null && useLocalNamespace) {
            namespace = symtab.getNamespace(addr);
        }
        symtab.createLabel(addr, name, namespace, source);
    }

    public static void deleteSymbol(SymbolTable symtab, Address addr, String name, Namespace space) throws InvalidInputException {
        Symbol s = symtab.getSymbol(name, addr, space);
        if (s == null) {
            throw new InvalidInputException("Symbol " + name + " not found!");
        }
        if (s.getSource() == SourceType.DEFAULT) {
            throw new InvalidInputException("Deleting the default symbol \"" + name + "\" @ " + addr + " is not allowed.");
        }
        boolean success = symtab.removeSymbolSpecial(s);
        if (!success) {
            throw new InvalidInputException("Couldn't delete the symbol \"" + name + "\" @ " + addr + ".");
        }
    }

    public static boolean clearNamespace(SymbolTable symtab, Namespace space) throws InvalidInputException {
        SymbolIterator iter = symtab.getSymbols(space);
        ArrayList<Address> addrlist = new ArrayList<Address>();
        ArrayList<String> namelist = new ArrayList<String>();
        while (iter.hasNext()) {
            Symbol sym = iter.next();
            if (!(sym instanceof CodeSymbol)) {
                return false;
            }
            addrlist.add(sym.getAddress());
            namelist.add(sym.getName());
        }
        for (int i = 0; i < addrlist.size(); ++i) {
            HighFunction.deleteSymbol(symtab, (Address)addrlist.get(i), (String)namelist.get(i), space);
        }
        return true;
    }

    public static Namespace findCreateNamespace(SymbolTable symtab, Namespace parentspace, String name) {
        Namespace res = HighFunction.findNamespace(symtab, parentspace, name);
        if (res == null) {
            try {
                return symtab.createNameSpace(parentspace, name, SourceType.USER_DEFINED);
            }
            catch (DuplicateNameException e) {
                return null;
            }
            catch (InvalidInputException e) {
                return null;
            }
        }
        return res;
    }

    public static XmlPullParser stringTree(InputStream xml, ErrorHandler handler) throws PcodeXMLException {
        try {
            XmlPullParser parser = XmlPullParserFactory.create((InputStream)xml, (String)"Decompiler Result Parser", (ErrorHandler)handler, (boolean)false);
            return parser;
        }
        catch (Exception e) {
            throw new PcodeXMLException("XML parsing error: " + e.getMessage(), e);
        }
    }

    public static void createNamespaceTag(StringBuilder buf, Namespace namespc) {
        if (namespc == null) {
            return;
        }
        ArrayList<String> arr = new ArrayList<String>();
        for (Namespace curspc = namespc; curspc != null; curspc = curspc.getParentNamespace()) {
            arr.add(0, curspc.getName());
        }
        buf.append("<val/>\n");
        for (int i = 1; i < arr.size(); ++i) {
            buf.append("<val>");
            SpecXmlUtils.xmlEscape((StringBuilder)buf, (String)((String)arr.get(i)));
            buf.append("</val>\n");
        }
    }

    public static String tagFindExclude(String tagname, String doc) {
        if (doc == null) {
            return null;
        }
        int length = tagname.length();
        int bindex = doc.indexOf("<" + tagname);
        if (bindex == -1) {
            return null;
        }
        if (bindex + length + 3 > doc.length()) {
            return null;
        }
        if (doc.charAt(bindex + length + 1) == '/') {
            return "";
        }
        int eindex = doc.indexOf("</" + tagname + ">");
        if (eindex == -1) {
            return null;
        }
        return doc.substring(bindex + length + 2, eindex);
    }
}

