/*
 * Decompiled with CFR 0.152.
 */
package docking.util.image;

import docking.util.image.CalloutComponentInfo;
import docking.util.image.DropShadow;
import generic.util.image.ImageUtils;
import java.awt.AWTException;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;

public class Callout {
    private static final Color CALLOUT_SHAPE_COLOR = new Color(181, 222, 47);
    private static final int CALLOUT_BORDER_PADDING = 20;

    public Image createCallout(CalloutComponentInfo calloutInfo) {
        int backgroundWidth;
        int newHeight;
        int calloutHeight;
        double distanceFactor = 1.15;
        Dimension cSize = calloutInfo.getSize();
        int calloutWidth = calloutHeight = (newHeight = cSize.height * 4);
        double xDistance = (double)calloutWidth * distanceFactor * 0.8;
        double yDistance = (double)calloutHeight * distanceFactor * distanceFactor;
        int padding = 0;
        Rectangle cBounds = calloutInfo.getBounds();
        Point cLoc = cBounds.getLocation();
        if (yDistance > (double)cLoc.y) {
            padding = (int)Math.round((double)calloutHeight * distanceFactor);
            cLoc.y += padding;
            cBounds.setLocation(cLoc.x, cLoc.y);
        }
        boolean goLeft = false;
        int calloutX = (int)((double)cLoc.x + (goLeft ? -(xDistance + (double)calloutWidth) : xDistance));
        int calloutY = (int)((double)cLoc.y + -yDistance);
        int backgroundHeight = backgroundWidth = calloutWidth;
        Rectangle calloutBounds = new Rectangle(calloutX, calloutY, backgroundWidth, backgroundHeight);
        Rectangle fullBounds = cBounds.union(calloutBounds);
        BufferedImage calloutImage = this.createCalloutImage(calloutInfo, cLoc, calloutBounds, fullBounds);
        return calloutImage;
    }

    public Image createCalloutOnImage(Image image, CalloutComponentInfo calloutInfo) {
        int backgroundWidth;
        int newHeight;
        int calloutHeight;
        Dimension cSize = calloutInfo.getSize();
        int calloutWidth = calloutHeight = (newHeight = cSize.height * 6);
        double distanceX = (double)calloutWidth * 1.5;
        double distanceY = calloutHeight * 2;
        int topPadding = 0;
        Rectangle componentBounds = calloutInfo.getBounds();
        Point componentLocation = componentBounds.getLocation();
        Point imageComponentLocation = calloutInfo.convertPointToParent(componentLocation);
        int calloutImageY = imageComponentLocation.y - (int)distanceY;
        if (calloutImageY < 0) {
            topPadding = Math.abs(calloutImageY) + 20;
            componentLocation.y += topPadding;
            componentBounds.setLocation(componentLocation.x, componentLocation.y);
        }
        double theta = Math.toRadians(45.0);
        int calloutX = (int)((double)componentLocation.x + Math.cos(theta) * distanceX);
        int calloutY = (int)((double)componentLocation.y - Math.sin(theta) * distanceY);
        int backgroundHeight = backgroundWidth = calloutWidth;
        Rectangle calloutBounds = new Rectangle(calloutX, calloutY, backgroundWidth, backgroundHeight);
        Rectangle calloutDrawingArea = componentBounds.union(calloutBounds);
        BufferedImage calloutImage = this.createCalloutImage(calloutInfo, componentLocation, calloutBounds, calloutDrawingArea);
        DropShadow dropShadow = new DropShadow();
        Image shadow = dropShadow.createDrowShadow(calloutImage, 40);
        Point calloutImageLoc = calloutInfo.convertPointToParent(calloutDrawingArea.getLocation());
        calloutDrawingArea.setLocation(calloutImageLoc);
        Rectangle dropShadowBounds = new Rectangle(calloutImageLoc.x, calloutImageLoc.y, shadow.getWidth(null), shadow.getHeight(null));
        Rectangle completeBounds = calloutDrawingArea.union(dropShadowBounds);
        int fullBoundsXEndpoint = calloutImageLoc.x + completeBounds.width;
        int overlap = fullBoundsXEndpoint - image.getWidth(null);
        int rightPadding = 0;
        if (overlap > 0) {
            rightPadding = overlap + 20;
        }
        int fullBoundsYEndpoint = calloutImageLoc.y + completeBounds.height;
        int bottomPadding = 0;
        overlap = fullBoundsYEndpoint - image.getHeight(null);
        if (overlap > 0) {
            bottomPadding = overlap;
        }
        image = ImageUtils.padImage((Image)image, (Color)Color.WHITE, (int)topPadding, (int)0, (int)rightPadding, (int)bottomPadding);
        Graphics g = image.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.drawImage(shadow, calloutImageLoc.x, calloutImageLoc.y, null);
        g2d.drawImage((Image)calloutImage, calloutImageLoc.x, calloutImageLoc.y, null);
        return image;
    }

    private BufferedImage createCalloutImage(CalloutComponentInfo calloutInfo, Point cLoc, Rectangle calloutBounds, Rectangle fullBounds) {
        BufferedImage calloutImage = new BufferedImage(fullBounds.width, fullBounds.height, 2);
        Graphics2D cg = (Graphics2D)calloutImage.getGraphics();
        cg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Point calloutOrigin = fullBounds.getLocation();
        int sx = calloutBounds.x - calloutOrigin.x;
        int sy = calloutBounds.y - calloutOrigin.y;
        Ellipse2D.Double calloutShape = new Ellipse2D.Double(sx, sy, calloutBounds.width, calloutBounds.height);
        int cx = cLoc.x - calloutOrigin.x;
        int cy = cLoc.y - calloutOrigin.y;
        Dimension cSize = calloutInfo.getSize();
        Rectangle componentShape = new Rectangle(new Point(cx, cy), cSize);
        this.paintCalloutArrow(cg, componentShape, calloutShape);
        this.paintCalloutCircularImage(cg, calloutInfo, calloutShape);
        cg.dispose();
        return calloutImage;
    }

    private void paintCalloutCircularImage(Graphics2D g, CalloutComponentInfo calloutInfo, RectangularShape shape) {
        g.setColor(CALLOUT_SHAPE_COLOR);
        g.fill(shape);
        int offset = 3;
        Rectangle sr = shape.getBounds();
        Rectangle ir = new Rectangle();
        ir.x = sr.x + offset;
        ir.y = sr.y + offset;
        ir.width = sr.width - 2 * offset;
        ir.height = sr.height - 2 * offset;
        shape.setFrame(ir);
        Dimension imageSize = ir.getSize();
        Image foregroundImage = this.createMagnifiedImage(g.getDeviceConfiguration(), imageSize, calloutInfo, shape);
        shape.setFrame(sr);
        g.drawImage(foregroundImage, ir.x, ir.y, null);
    }

    private void paintCalloutArrow(Graphics2D g2d, RectangularShape componentShape, RectangularShape calloutShape) {
        Rectangle cr = componentShape.getBounds();
        Rectangle sr = calloutShape.getBounds();
        Point p1 = new Point((int)cr.getCenterX(), (int)cr.getCenterY());
        Point p2 = new Point(sr.x + sr.width / 2, sr.y + sr.height / 2);
        int radius = sr.width / 2;
        int dx = p2.x - p1.x;
        int dy = p2.y - p1.y;
        double distance = Math.sqrt(dx * dx + dy * dy);
        double alpha = Math.asin((double)radius / distance);
        double beta = Math.atan2(dy, dx);
        double theta = beta - alpha;
        double x = (double)radius * Math.sin(theta) + (double)p2.x;
        double y = (double)radius * -Math.cos(theta) + (double)p2.y;
        Point tangentA = new Point((int)Math.round(x), (int)Math.round(y));
        theta = beta + alpha;
        x = (double)radius * -Math.sin(theta) + (double)p2.x;
        y = (double)radius * Math.cos(theta) + (double)p2.y;
        Point tangentB = new Point((int)Math.round(x), (int)Math.round(y));
        g2d.setColor(CALLOUT_SHAPE_COLOR);
        Polygon p = new Polygon();
        p.addPoint(p1.x, p1.y);
        p.addPoint(tangentA.x, tangentA.y);
        p.addPoint(tangentB.x, tangentB.y);
        g2d.fillPolygon(p);
    }

    private Image createMagnifiedImage(GraphicsConfiguration gc, Dimension imageSize, CalloutComponentInfo calloutInfo, RectangularShape imageShape) {
        Dimension componentSize = calloutInfo.getSize();
        Point componentScreenLocation = calloutInfo.getLocationOnScreen();
        Rectangle r = new Rectangle(componentScreenLocation, componentSize);
        int offset = 100;
        r.x -= offset;
        r.y -= offset;
        r.width += 2 * offset;
        r.height += 2 * offset;
        Image compImage = null;
        try {
            Robot robot = new Robot();
            compImage = robot.createScreenCapture(r);
        }
        catch (AWTException e) {
            throw new RuntimeException("boom", e);
        }
        double magnification = calloutInfo.getMagnification();
        int newWidth = (int)((double)compImage.getWidth(null) * magnification);
        int newHeight = (int)((double)compImage.getHeight(null) * magnification);
        compImage = ImageUtils.createScaledImage((Image)compImage, (int)newWidth, (int)newHeight, (int)0);
        Rectangle bounds = imageShape.getBounds();
        VolatileImage image = gc.createCompatibleVolatileImage(bounds.width, bounds.height, 3);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setComposite(AlphaComposite.Clear);
        Rectangle relativeFrame = new Rectangle(new Point(0, 0), bounds.getSize());
        imageShape.setFrame(relativeFrame);
        g.fill(relativeFrame);
        g.setComposite(AlphaComposite.Src);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.WHITE);
        g.fill(imageShape);
        imageShape.setFrame(bounds);
        g.setComposite(AlphaComposite.SrcAtop);
        int cw = compImage.getWidth(null);
        int ch = compImage.getHeight(null);
        int x = -(cw / 2 - bounds.width / 2);
        int y = -(ch / 2 - bounds.height / 2);
        g.drawImage(compImage, x, y, cw, ch, null);
        g.dispose();
        return image;
    }
}

