/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.internal;

import docking.widgets.fieldpanel.internal.EmptyLayoutBackgroundColorManager;
import docking.widgets.fieldpanel.internal.LayoutBackgroundColorManager;
import docking.widgets.fieldpanel.internal.MixedLayoutBackgroundColorManager;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.FieldSelection;
import java.awt.Color;
import java.math.BigInteger;

public class LayoutColorMapFactory {
    public static LayoutBackgroundColorManager getLayoutColorMap(BigInteger index, FieldSelection selection, FieldSelection highlight, Color backgroundColor, Color selectionColor, Color highlightColor, Color mixedColor) {
        boolean isTotallyHighlighted;
        FieldSelection selectionIntersect = selection.intersect(index);
        FieldSelection highlightIntersect = highlight.intersect(index);
        if (selectionIntersect.isEmpty() && highlightIntersect.isEmpty()) {
            return new EmptyLayoutBackgroundColorManager(backgroundColor);
        }
        boolean isTotallySelected = selectionIntersect.getNumRanges() == 1 && selectionIntersect.getFieldRange(0).containsEntirely(index);
        boolean bl = isTotallyHighlighted = highlightIntersect.getNumRanges() == 1 && highlightIntersect.getFieldRange(0).containsEntirely(index);
        if (isTotallySelected && isTotallyHighlighted) {
            return new EmptyLayoutBackgroundColorManager(mixedColor);
        }
        if (isTotallySelected && highlightIntersect.isEmpty()) {
            return new EmptyLayoutBackgroundColorManager(selectionColor);
        }
        if (isTotallyHighlighted && selectionIntersect.isEmpty()) {
            return new EmptyLayoutBackgroundColorManager(highlightColor);
        }
        FieldLocation startOfLine = new FieldLocation(index, 0, 0, 0);
        FieldLocation endOfLine = new FieldLocation(index, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        boolean leftBorderSelected = selection.contains(startOfLine);
        boolean rightBorderSelected = selection.contains(endOfLine);
        boolean leftBorderHighlighted = highlight.contains(startOfLine);
        boolean rightBorderHighlighted = highlight.contains(endOfLine);
        Color leftBorderColor = backgroundColor;
        if (leftBorderSelected && leftBorderHighlighted) {
            leftBorderColor = mixedColor;
        } else if (leftBorderSelected) {
            leftBorderColor = selectionColor;
        } else if (leftBorderHighlighted) {
            leftBorderColor = highlightColor;
        }
        Color rightBorderColor = backgroundColor;
        if (leftBorderSelected && rightBorderHighlighted) {
            rightBorderColor = mixedColor;
        } else if (rightBorderSelected) {
            rightBorderColor = selectionColor;
        } else if (rightBorderHighlighted) {
            rightBorderColor = highlightColor;
        }
        return new MixedLayoutBackgroundColorManager(index, selectionIntersect, highlightIntersect, backgroundColor, selectionColor, highlightColor, mixedColor, leftBorderColor, rightBorderColor);
    }
}

