/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.DynamicTableColumn;
import ghidra.docking.settings.FloatingPointPrecisionSettingsDefinition;
import ghidra.docking.settings.FormatSettingsDefinition;
import ghidra.docking.settings.IntegerSignednessFormattingModeSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.util.NumericUtilities;
import ghidra.util.table.column.GColumnRenderer;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import utilities.util.reflection.ReflectionUtilities;

public abstract class AbstractDynamicTableColumn<ROW_TYPE, COLUMN_TYPE, DATA_SOURCE>
implements DynamicTableColumn<ROW_TYPE, COLUMN_TYPE, DATA_SOURCE> {
    public static SettingsDefinition[] NO_SETTINGS_DEFINITIONS = new SettingsDefinition[0];
    protected static final FormatSettingsDefinition INTEGER_RADIX_SETTING = FormatSettingsDefinition.DEF_DECIMAL;
    protected static final IntegerSignednessFormattingModeSettingsDefinition INTEGER_SIGNEDNESS_MODE_SETTING = IntegerSignednessFormattingModeSettingsDefinition.DEF;
    protected static final FloatingPointPrecisionSettingsDefinition FLOATING_POINT_PRECISION_SETTING = FloatingPointPrecisionSettingsDefinition.DEF;
    protected static SettingsDefinition[] INTEGER_SETTINGS_DEFINITIONS = new SettingsDefinition[]{INTEGER_RADIX_SETTING, INTEGER_SIGNEDNESS_MODE_SETTING};
    protected static SettingsDefinition[] FLOATING_POINT_SETTINGS_DEFINITIONS = new SettingsDefinition[]{FLOATING_POINT_PRECISION_SETTING};
    private boolean hasConfiguredDefaultSettings = false;
    private SettingsDefinition[] defaultSettingsDefinitions = NO_SETTINGS_DEFINITIONS;
    private String identifier;

    public AbstractDynamicTableColumn() {
    }

    protected AbstractDynamicTableColumn(String identifier) {
        this.identifier = Objects.requireNonNull(identifier);
    }

    @Override
    public abstract String getColumnName();

    @Override
    public int getColumnPreferredWidth() {
        return -1;
    }

    @Override
    public Comparator<COLUMN_TYPE> getComparator() {
        return null;
    }

    @Override
    public Class<COLUMN_TYPE> getColumnClass() {
        Class<?> implementationClass = this.getClass();
        List typeArguments = ReflectionUtilities.getTypeArguments(AbstractDynamicTableColumn.class, implementationClass);
        return (Class)typeArguments.get(1);
    }

    @Override
    public Class<ROW_TYPE> getSupportedRowType() {
        Class<?> implementationClass = this.getClass();
        List typeArguments = ReflectionUtilities.getTypeArguments(AbstractDynamicTableColumn.class, implementationClass);
        return (Class)typeArguments.get(0);
    }

    @Override
    public abstract COLUMN_TYPE getValue(ROW_TYPE var1, Settings var2, DATA_SOURCE var3, ServiceProvider var4) throws IllegalArgumentException;

    @Override
    public GColumnRenderer<COLUMN_TYPE> getColumnRenderer() {
        return null;
    }

    private void configureDefaultSettings() {
        this.defaultSettingsDefinitions = NO_SETTINGS_DEFINITIONS;
        Class<COLUMN_TYPE> columnClass = this.getColumnClass();
        if (NumericUtilities.isIntegerType(columnClass)) {
            this.defaultSettingsDefinitions = INTEGER_SETTINGS_DEFINITIONS;
        } else if (NumericUtilities.isFloatingPointType(columnClass)) {
            this.defaultSettingsDefinitions = FLOATING_POINT_SETTINGS_DEFINITIONS;
        }
        this.hasConfiguredDefaultSettings = true;
    }

    @Override
    public SettingsDefinition[] getSettingsDefinitions() {
        if (!this.hasConfiguredDefaultSettings) {
            this.configureDefaultSettings();
        }
        return this.defaultSettingsDefinitions;
    }

    @Override
    public int getMaxLines(Settings settings) {
        return 1;
    }

    @Override
    public String getColumnDisplayName(Settings settings) {
        return this.getColumnName();
    }

    @Override
    public String getColumnDescription() {
        Class<ROW_TYPE> type = this.getSupportedRowType();
        if (type == null) {
            return null;
        }
        String rowClassName = type.getSimpleName();
        return this.getColumnName() + " (for row type: " + rowClassName + ")";
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractDynamicTableColumn)) {
            return false;
        }
        AbstractDynamicTableColumn dynamicTableColumn = (AbstractDynamicTableColumn)obj;
        return this.getUniqueIdentifier().equals(dynamicTableColumn.getUniqueIdentifier());
    }

    public final int hashCode() {
        return this.getIdentifier().hashCode();
    }

    private String getIdentifier() {
        if (this.identifier == null) {
            this.identifier = this.getClass().getName() + "." + this.getColumnName();
        }
        return this.identifier;
    }

    @Override
    public final String getUniqueIdentifier() {
        return this.getIdentifier();
    }

    public String toString() {
        return this.getColumnName();
    }
}

