/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.table.TableCellRenderer;

public class DefaultTableCellRendererWrapper
extends GTableCellRenderer {
    private final TableCellRenderer renderer;

    public DefaultTableCellRendererWrapper(TableCellRenderer renderer) {
        this.renderer = renderer;
        this.setHTMLRenderingEnabled(false);
    }

    @Override
    public void setHTMLRenderingEnabled(boolean enable) {
        if (this.renderer instanceof JComponent) {
            ((JComponent)((Object)this.renderer)).putClientProperty("html.disable", !enable);
        }
        super.setHTMLRenderingEnabled(enable);
    }

    @Override
    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        Component rendererComponent = this.renderer.getTableCellRendererComponent(data.getTable(), data.getValue(), data.isSelected(), data.hasFocus(), data.getRowViewIndex(), data.getColumnViewIndex());
        JComponent thisRenderer = (JComponent)super.getTableCellRendererComponent(data);
        rendererComponent.setBackground(thisRenderer.getBackground());
        if (rendererComponent instanceof JComponent) {
            ((JComponent)rendererComponent).setBorder(thisRenderer.getBorder());
        }
        return rendererComponent;
    }
}

