/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree;

import docking.widgets.tree.CoreGTreeNode;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeRootNode;
import docking.widgets.tree.support.GTreeFilter;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.tree.TreePath;

public abstract class AbstractGTreeNode
extends CoreGTreeNode {
    private AtomicBoolean isFiltering = new AtomicBoolean();

    protected void loadChildren() {
    }

    @Override
    public void addNode(GTreeNode node) {
        this.addNode(-1, node);
    }

    @Override
    public void addNode(int index, GTreeNode node) {
        this.doAddNode(index, node);
        GTreeFilter filter = this.getFilter();
        if (filter != null) {
            GTree tree = this.getTree();
            tree.scheduleFilterTask(this);
        }
    }

    @Override
    public int compareTo(GTreeNode node) {
        return this.getName().compareToIgnoreCase(node.getName());
    }

    @Override
    public List<GTreeNode> getAllChildren() {
        this.loadChildren();
        return this.doGetAllChildren();
    }

    @Override
    public List<GTreeNode> getChildren() {
        this.loadChildren();
        return this.doGetActiveChildren();
    }

    @Override
    public int getChildCount() {
        this.loadChildren();
        return this.doGetChildCount();
    }

    @Override
    public int getAllChildCount() {
        this.loadChildren();
        return this.doGetAllChildCount();
    }

    @Override
    public GTreeNode getChild(String name) {
        List<GTreeNode> children = this.getChildren();
        for (GTreeNode child : children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    @Override
    public GTreeNode getChild(int index) {
        this.loadChildren();
        return this.doGetChild(index);
    }

    @Override
    public int getNodeCount() {
        List<GTreeNode> children = this.getChildren();
        int count = 1;
        for (GTreeNode child : children) {
            count += child.getNodeCount();
        }
        return count;
    }

    @Override
    public int getLeafCount() {
        if (this.isLeaf()) {
            return 1;
        }
        if (!this.isChildrenLoadedOrInProgress()) {
            return 0;
        }
        List<GTreeNode> children = this.getChildren();
        int count = 0;
        for (GTreeNode child : children) {
            count += child.getLeafCount();
        }
        return count;
    }

    @Override
    public int getIndexInParent() {
        GTreeNode myParent = this.getParent();
        if (myParent != null) {
            return myParent.getIndexOfChild(this);
        }
        return -1;
    }

    @Override
    public int getIndexOfChild(GTreeNode node) {
        this.loadChildren();
        return this.doGetIndexOfChild(node);
    }

    @Override
    public TreePath getTreePath() {
        return new TreePath(this.getPathToRoot(this, 0));
    }

    @Override
    public void removeAll() {
        if (!this.isChildrenLoadedOrInProgress()) {
            return;
        }
        List<GTreeNode> allChildren = this.getAllChildren();
        this.doSetChildren(null, true);
        for (GTreeNode gTreeNode : allChildren) {
            gTreeNode.dispose();
        }
    }

    @Override
    public void setChildren(List<GTreeNode> childList) {
        this.doSetChildren(childList, true);
        if (this.isFiltering.get()) {
            return;
        }
        GTreeFilter filter = this.getFilter();
        if (filter != null) {
            GTree tree = this.getTree();
            tree.scheduleFilterTask(this);
        }
    }

    @Override
    public boolean isAncestor(GTreeNode node) {
        for (GTreeNode nodeParent = node.getParent(); nodeParent != null; nodeParent = nodeParent.getParent()) {
            if (!nodeParent.equals(this)) continue;
            return true;
        }
        return false;
    }

    public Iterable<TreePath> allPaths() {
        return new AllPathsIterable(new TreePath(this));
    }

    @Override
    public Iterator<GTreeNode> iterator() {
        return this.getChildren().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void filter(GTreeFilter filter, TaskMonitor monitor, int min, int max) throws CancelledException {
        if (this.isFiltering.get()) {
            this.stopCurrentFilterAndRestart();
            return;
        }
        this.isFiltering.set(true);
        try {
            this.doFilter(filter, monitor, min, max);
        }
        finally {
            this.isFiltering.set(false);
        }
    }

    private void stopCurrentFilterAndRestart() {
        GTree tree = this.getTree();
        if (tree != null) {
            tree.refilter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFilter(GTreeFilter filter, TaskMonitor monitor, int min, int max) throws CancelledException {
        if (this.isLeaf()) {
            return;
        }
        List<GTreeNode> allChildren = this.getAllChildren();
        if (allChildren.size() == 0) {
            return;
        }
        List<GTreeNode> newChildren = allChildren;
        try {
            this.setInProgress();
            ArrayList<GTreeNode> filteredChildren = new ArrayList<GTreeNode>();
            monitor.setProgress((long)min);
            int progressChunkSize = (max - min) / allChildren.size();
            int childMin = min;
            for (GTreeNode child : allChildren) {
                monitor.checkCanceled();
                child.filter(filter, monitor, childMin, childMin + progressChunkSize);
                if (filter.acceptsNode(child) || child.getChildCount() > 0) {
                    filteredChildren.add(child);
                }
                childMin += progressChunkSize;
            }
            newChildren = filteredChildren;
        }
        finally {
            this.doSetActiveChildren(newChildren);
        }
        monitor.setProgress((long)max);
    }

    @Override
    public void clearFilter() {
        if (this.isLeaf()) {
            return;
        }
        if (!this.isChildrenLoaded()) {
            return;
        }
        List<GTreeNode> allChildren = this.getAllChildren();
        if (allChildren.size() == 0) {
            return;
        }
        this.setInProgress();
        for (GTreeNode child : allChildren) {
            child.clearFilter();
        }
        this.doResetActiveChildren();
    }

    @Override
    public boolean isFilteredOut() {
        if (this.getParent() == null) {
            return false;
        }
        return this.getIndexInParent() < 0;
    }

    @Override
    public void valueChanged(Object newValue) {
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public GTreeRootNode getRoot() {
        GTreeNode myParent = this.getParent();
        if (myParent == null) {
            if (this instanceof GTreeRootNode) {
                return (GTreeRootNode)((Object)this);
            }
            throw new AssertException("Found a root node that is not an instance of GTreeRootNode--stop it!");
        }
        return myParent.getRoot();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public GTree getTree() {
        GTreeNode myParent = this.getParent();
        if (myParent != null) {
            return myParent.getTree();
        }
        if (this instanceof GTreeRootNode) {
            return ((GTreeRootNode)((Object)this)).getGTree();
        }
        return null;
    }

    private GTreeNode[] getPathToRoot(GTreeNode node, int depth) {
        GTreeNode[] returnNodes;
        if (node == null) {
            if (depth == 0) {
                return null;
            }
            returnNodes = new GTreeNode[depth];
        } else {
            returnNodes = this.getPathToRoot(node.getParent(), ++depth);
            returnNodes[returnNodes.length - depth] = node;
        }
        return returnNodes;
    }

    protected GTreeFilter getFilter() {
        GTree tree = this.getTree();
        if (tree != null) {
            return tree.getFilter();
        }
        return null;
    }

    private static class AllPathsIterable
    implements Iterable<TreePath> {
        private TreePath path;

        public AllPathsIterable(TreePath path) {
            this.path = path;
        }

        @Override
        public Iterator<TreePath> iterator() {
            return new AllPathsIterator(this.path);
        }
    }

    public static class AllPathsIterator
    implements Iterator<TreePath> {
        private TreePath ancestry;
        private TreePath nextPath;
        private Iterator<GTreeNode> childIt = null;
        private Iterator<TreePath> childPathIt = null;

        public AllPathsIterator(TreePath path) {
            this.ancestry = path;
            this.nextPath = path;
        }

        @Override
        public boolean hasNext() {
            return this.nextPath != null;
        }

        @Override
        public TreePath next() {
            TreePath n = this.nextPath;
            this.loadNext();
            return n;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected void loadNext() {
            if (this.childIt == null) {
                Object obj = this.ancestry.getLastPathComponent();
                assert (obj instanceof GTreeNode);
                this.childIt = ((GTreeNode)obj).iterator();
            }
            if (this.childPathIt == null || !this.childPathIt.hasNext()) {
                this.childPathIt = this.childIt.hasNext() ? new AllPathsIterator(this.ancestry.pathByAddingChild(this.childIt.next())) : null;
            }
            this.nextPath = this.childPathIt != null && this.childPathIt.hasNext() ? this.childPathIt.next() : null;
        }
    }
}

