/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.task;

import ghidra.util.Swing;
import ghidra.util.task.MonitoredRunnable;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskRunner;
import java.awt.Component;

public class TaskLauncher {
    static final int INITIAL_DELAY_MS = 1000;
    static final int INITIAL_MODAL_DELAY_MS = 500;

    public static <T extends Task> T launch(T task) {
        new TaskLauncher(task);
        return task;
    }

    public static void launchNonModal(String title, final MonitoredRunnable runnable) {
        new TaskLauncher(new Task(title, true, true, false){

            public void run(TaskMonitor monitor) {
                runnable.monitoredRun(monitor);
            }
        }, null, 1000);
    }

    public static void launchModal(String title, final MonitoredRunnable runnable) {
        new TaskLauncher(new Task(title, true, true, true){

            public void run(TaskMonitor monitor) {
                runnable.monitoredRun(monitor);
            }
        }, null, 500);
    }

    public static void launchModal(String title, final Runnable runnable) {
        Task t = new Task(title, false, false, true){

            public void run(TaskMonitor monitor) {
                runnable.run();
            }
        };
        int delay = 0;
        new TaskLauncher(t, null, delay);
    }

    public TaskLauncher(Task task) {
        this(task, null, task.isModal() ? 500 : 1000);
    }

    public TaskLauncher(Task task, Component parent) {
        this(task, TaskLauncher.getParent(parent), task.isModal() ? 500 : 1000);
    }

    public TaskLauncher(Task task, Component parent, int delayMs) {
        this(task, parent, delayMs, 275);
    }

    public TaskLauncher(Task task, Component parent, int delayMs, int dialogWidth) {
        TaskRunner runner = this.createTaskRunner(task, parent, delayMs, dialogWidth);
        runner.run();
    }

    protected TaskRunner createTaskRunner(Task task, Component parent, int delayMs, int dialogWidth) {
        return new TaskRunner(task, parent, delayMs, dialogWidth);
    }

    protected void runInThisBackgroundThread(Task task) {
        if (Swing.isSwingThread()) {
            throw new IllegalStateException("Must not call this method from the Swing thread");
        }
        task.monitoredRun(TaskMonitor.DUMMY);
    }

    private static Component getParent(Component parent) {
        if (parent == null) {
            return null;
        }
        return parent.isVisible() ? parent : null;
    }
}

