/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.feature.vt.api.main.VTMarkupItemApplyActionType;
import ghidra.feature.vt.gui.actions.AbstractMarkupItemAction;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.provider.markuptable.MarkupStatusIcons;
import ghidra.feature.vt.gui.util.VTMatchApplyChoices;
import ghidra.framework.options.ToolOptions;
import ghidra.util.HelpLocation;

public class ApplyAndAddMarkupItemAction
extends AbstractMarkupItemAction {
    private static final String MENU_GROUP = "A_VT_Apply_Edit";

    public ApplyAndAddMarkupItemAction(VTController controller, boolean addToToolbar) {
        super(controller, "Apply (Add)");
        if (addToToolbar) {
            this.setToolBarData(new ToolBarData(MarkupStatusIcons.APPLY_ADD_MENU_ICON, MENU_GROUP));
        }
        MenuData menuData = new MenuData(new String[]{"Apply (Add)"}, MarkupStatusIcons.APPLY_ADD_MENU_ICON, MENU_GROUP);
        menuData.setMenuSubGroup("1");
        this.setPopupMenuData(menuData);
        this.setEnabled(false);
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Add_Markup_Item"));
    }

    @Override
    public ToolOptions getApplyOptions() {
        ToolOptions options = this.controller.getOptions();
        ToolOptions vtOptions = options.copy();
        vtOptions.setEnum("Apply Markup Options.Function Name", (Enum)VTMatchApplyChoices.FunctionNameChoices.ADD);
        vtOptions.setEnum("Apply Markup Options.Labels", (Enum)VTMatchApplyChoices.LabelChoices.ADD);
        vtOptions.setEnum("Apply Markup Options.Plate Comment", (Enum)VTMatchApplyChoices.CommentChoices.APPEND_TO_EXISTING);
        vtOptions.setEnum("Apply Markup Options.Pre Comment", (Enum)VTMatchApplyChoices.CommentChoices.APPEND_TO_EXISTING);
        vtOptions.setEnum("Apply Markup Options.End of Line Comment", (Enum)VTMatchApplyChoices.CommentChoices.APPEND_TO_EXISTING);
        vtOptions.setEnum("Apply Markup Options.Repeatable Comment", (Enum)VTMatchApplyChoices.CommentChoices.APPEND_TO_EXISTING);
        vtOptions.setEnum("Apply Markup Options.Post Comment", (Enum)VTMatchApplyChoices.CommentChoices.APPEND_TO_EXISTING);
        return vtOptions;
    }

    @Override
    public VTMarkupItemApplyActionType getActionType() {
        return VTMarkupItemApplyActionType.ADD;
    }
}

