/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.tray;

import io.netty.util.internal.logging.SimpleLogger;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.rzo.yajsw.config.YajswConfigurationImpl;
import org.rzo.yajsw.tray.WrapperTrayIconFactory;
import org.rzo.yajsw.tray.WrapperTrayIconImpl;
import org.rzo.yajsw.tray.ahessian.client.AHessianJmxClient;
import org.rzo.yajsw.util.Utils;
import org.rzo.yajsw.wrapper.AbstractWrappedProcessMBean;
import org.rzo.yajsw.wrapper.TrayIconProxy;

public class TrayIconMain {
    static volatile MBeanServerConnection jmxc = null;
    static JMXServiceURL url = null;
    static String user = null;
    static String password = null;
    static volatile AbstractWrappedProcessMBean proxy = null;
    static ObjectName oName = null;
    static WrapperTrayIconImpl _trayIcon = null;
    static FileLock lock = null;
    static AHessianJmxClient _ahessianClient;

    private static String getName(Configuration _config) {
        String name;
        String result = "";
        if (_config == null) {
            return result;
        }
        if (_config.getBoolean("wrapper.service", false)) {
            result = result + "Service ";
        }
        if ((name = _config.getString("wrapper.console.title")) == null) {
            name = _config.getString("wrapper.ntservice.name");
        }
        if (name == null) {
            name = _config.getString("wrapper.image");
        }
        if (name == null) {
            name = _config.getString("wrapper.groovy");
        }
        if (name == null) {
            name = _config.getString("wrapper.java.app.mainclass");
        }
        if (name == null) {
            name = _config.getString("wrapper.java.app.jar");
        }
        if (name == null) {
            name = "";
        }
        result = result + name;
        return result;
    }

    public static void main(String[] args) throws Exception {
        File f;
        String config = null;
        if (args.length > 0) {
            config = args[0];
        }
        if (!(f = new File(config)).exists()) {
            System.out.println("file not found " + f);
            config = null;
        }
        String canonName = null;
        if (config != null) {
            canonName = new File(config).getCanonicalPath();
            String tmpDir = System.getProperty("jna_tmpdir", System.getProperty("java.io.tmpdir"));
            File lockFile = new File(tmpDir + "/yajsw" + canonName.hashCode() + ".lck");
            FileChannel channel = new RandomAccessFile(lockFile, "rw").getChannel();
            try {
                lock = channel.tryLock();
            }
            catch (OverlappingFileLockException e) {
                return;
            }
            if (lock == null) {
                return;
            }
        }
        System.setProperty("wrapper.config", config);
        BaseConfiguration localConf = new BaseConfiguration();
        if (config != null) {
            localConf.addProperty("wrapper.config", (Object)config);
        }
        YajswConfigurationImpl _config = new YajswConfigurationImpl((Configuration)localConf, true);
        try {
            String name = _config.getString("wrapper.console.title");
            if (name == null) {
                name = _config.getString("wrapper.ntservice.name");
            }
            if (name == null) {
                name = "yajsw.noname";
            }
            name = ObjectName.quote(name);
            oName = new ObjectName("org.rzo.yajsw", "name", name);
            _trayIcon = (WrapperTrayIconImpl)WrapperTrayIconFactory.createTrayIcon(TrayIconMain.getName((Configuration)_config), _config.getString("wrapper.tray.icon"), _config);
            Utils.verifyIPv4IsPreferred(null);
            _ahessianClient = new AHessianJmxClient(canonName, _config.getInt("wrapper.tray.port", 0), true, new SimpleLogger());
            _ahessianClient.setConnectListener(new Runnable(){

                @Override
                public void run() {
                    if (_trayIcon.isStop()) {
                        return;
                    }
                    try {
                        jmxc = _ahessianClient.getMBeanServer();
                        if (jmxc != null) {
                            proxy = MBeanServerInvocationHandler.newProxyInstance(jmxc, oName, AbstractWrappedProcessMBean.class, false);
                            _trayIcon.setProcess(proxy);
                            _ahessianClient.open();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            _ahessianClient.setDisconnectListener(new Runnable(){

                @Override
                public void run() {
                    jmxc = null;
                    proxy = null;
                    try {
                        _trayIcon.closeConsole();
                        _trayIcon.setProcess(null);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            _ahessianClient.start();
            while (!_trayIcon.isStop()) {
                if (jmxc != null && proxy != null) {
                    try {
                        if (!TrayIconMain.showInquire(proxy.getInquireMessage())) {
                            TrayIconMain.showMessages(proxy.getTrayIconMessages());
                            _trayIcon.showState(proxy.getState());
                            _trayIcon.showColor(proxy.getUserTrayColor());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        System.out.println("error accessing server " + ex);
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    System.out.println(e.getMessage());
                }
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            return;
        }
        Runtime.getRuntime().halt(0);
    }

    private static boolean showInquire(String message) {
        if (message == null) {
            return false;
        }
        if (_trayIcon == null) {
            return false;
        }
        if (TrayIconMain._trayIcon._inquireMessage == null) {
            _trayIcon.message("Input Required", message + "\n enter data through response menue");
            TrayIconMain._trayIcon._inquireMessage = message;
            return true;
        }
        return true;
    }

    private static void showMessages(String[][] messages) {
        if (_trayIcon == null) {
            return;
        }
        if (messages == null) {
            return;
        }
        block6: for (String[] message : messages) {
            TrayIconProxy.Types type = TrayIconProxy.Types.valueOf(message[0]);
            switch (type) {
                case ERROR: {
                    _trayIcon.error(message[1], message[2]);
                    continue block6;
                }
                case INFO: {
                    _trayIcon.info(message[1], message[2]);
                    continue block6;
                }
                case MESSAGE: {
                    _trayIcon.message(message[1], message[2]);
                    continue block6;
                }
                case WARNING: {
                    _trayIcon.warning(message[1], message[2]);
                    continue block6;
                }
                default: {
                    System.out.println("wrong message type");
                }
            }
        }
    }
}

