/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.updater;

import com.sun.jna.PlatformEx;
import java.util.ArrayList;
import org.rzo.yajsw.os.ms.win.w32.WindowsXPProcess;
import org.rzo.yajsw.wrapper.WrappedService;

public class InstallerMain {
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("missing new or current configuration -> abort");
            return;
        }
        InstallerMain.uninstallService(args[0]);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        InstallerMain.installService(args[1]);
    }

    private static void installService(String newAppConfig) {
        WrappedService service = new WrappedService();
        ArrayList<String> list = new ArrayList<String>();
        list.add(newAppConfig);
        service.setConfFilesList(list);
        service.init();
        service.uninstall();
        boolean result = service.install();
        if (PlatformEx.isWinVista() && service.requiresElevate()) {
            System.out.println("try uac elevate");
            WindowsXPProcess.elevateMe();
            return;
        }
        if (result && System.getProperty("update.autostart") != null) {
            service.start();
        } else if (!result) {
            System.out.println("error installing");
        }
    }

    private static void uninstallService(String currentConfig) {
        WrappedService service = new WrappedService();
        ArrayList<String> list = new ArrayList<String>();
        list.add(currentConfig);
        service.init();
        service.stop();
        service.uninstall();
    }
}

