/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.dmgextractor.io;

import org.catacombae.io.BasicReadableRandomAccessStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.RuntimeIOException;

public class SynchronizedRandomAccessStream
extends BasicReadableRandomAccessStream {
    private ReadableRandomAccessStream ras;

    public SynchronizedRandomAccessStream(ReadableRandomAccessStream ras) {
        this.ras = ras;
    }

    public synchronized int readFrom(long pos, byte[] b, int off, int len) throws RuntimeIOException {
        if (this.getFilePointer() != pos) {
            this.seek(pos);
        }
        return this.read(b, off, len);
    }

    public synchronized long skipFrom(long pos, long length) throws RuntimeIOException {
        long newPos = pos + length;
        long streamLength = this.length();
        if (newPos > streamLength) {
            this.seek(streamLength);
            return streamLength - pos;
        }
        this.seek(newPos);
        return length;
    }

    public synchronized long remainingLength() throws RuntimeIOException {
        return this.length() - this.getFilePointer();
    }

    public synchronized void close() throws RuntimeIOException {
        this.ras.close();
    }

    public synchronized long getFilePointer() throws RuntimeIOException {
        return this.ras.getFilePointer();
    }

    public synchronized long length() throws RuntimeIOException {
        return this.ras.length();
    }

    public synchronized int read() throws RuntimeIOException {
        return this.ras.read();
    }

    public synchronized int read(byte[] b) throws RuntimeIOException {
        return this.ras.read(b);
    }

    public synchronized int read(byte[] b, int off, int len) throws RuntimeIOException {
        return this.ras.read(b, off, len);
    }

    public synchronized void seek(long pos) throws RuntimeIOException {
        this.ras.seek(pos);
    }
}

