/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.client;

import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Calendar;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.rmi.client.ClientItem;
import org.apache.jackrabbit.rmi.client.LocalAdapterFactory;
import org.apache.jackrabbit.rmi.client.RemoteRepositoryException;
import org.apache.jackrabbit.rmi.remote.RemoteProperty;
import org.apache.jackrabbit.rmi.value.SerialValueFactory;

public class ClientProperty
extends ClientItem
implements Property {
    private RemoteProperty remote;

    public ClientProperty(Session session, RemoteProperty remote, LocalAdapterFactory factory) {
        super(session, remote, factory);
        this.remote = remote;
    }

    public void accept(ItemVisitor visitor) throws RepositoryException {
        visitor.visit((Property)this);
    }

    public boolean getBoolean() throws RepositoryException {
        return this.getValue().getBoolean();
    }

    public Calendar getDate() throws RepositoryException {
        return this.getValue().getDate();
    }

    public double getDouble() throws RepositoryException {
        return this.getValue().getDouble();
    }

    public long getLong() throws RepositoryException {
        return this.getValue().getLong();
    }

    public InputStream getStream() throws RepositoryException {
        return this.getValue().getStream();
    }

    public String getString() throws RepositoryException {
        return this.getValue().getString();
    }

    public Value getValue() throws RepositoryException {
        try {
            return this.remote.getValue();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public Value[] getValues() throws RepositoryException {
        try {
            return this.remote.getValues();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public void setValue(boolean value) throws RepositoryException {
        this.setValue(this.getSession().getValueFactory().createValue(value));
    }

    public void setValue(Calendar value) throws RepositoryException {
        if (value == null) {
            this.setValue((Value)null);
        } else {
            this.setValue(this.getSession().getValueFactory().createValue(value));
        }
    }

    public void setValue(double value) throws RepositoryException {
        this.setValue(this.getSession().getValueFactory().createValue(value));
    }

    public void setValue(InputStream value) throws RepositoryException {
        if (value == null) {
            this.setValue((Value)null);
        } else {
            this.setValue(this.getSession().getValueFactory().createValue(value));
        }
    }

    public void setValue(long value) throws RepositoryException {
        this.setValue(this.getSession().getValueFactory().createValue(value));
    }

    public void setValue(Node value) throws RepositoryException {
        if (value == null) {
            this.setValue((Value)null);
        } else {
            this.setValue(this.getSession().getValueFactory().createValue(value));
        }
    }

    public void setValue(String value) throws RepositoryException {
        if (value == null) {
            this.setValue((Value)null);
        } else {
            this.setValue(this.getSession().getValueFactory().createValue(value));
        }
    }

    public void setValue(String[] strings) throws RepositoryException {
        if (strings == null) {
            this.setValue((Value[])null);
        } else {
            Value[] values = new Value[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                values[i] = this.getSession().getValueFactory().createValue(strings[i]);
            }
            this.setValue(values);
        }
    }

    public void setValue(Value value) throws RepositoryException {
        try {
            if (value == null) {
                this.remote.setValue((Value)null);
            } else {
                this.remote.setValue(SerialValueFactory.makeSerialValue(value));
            }
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public void setValue(Value[] values) throws RepositoryException {
        try {
            if (values == null) {
                this.remote.setValue((Value[])null);
            } else {
                this.remote.setValue(SerialValueFactory.makeSerialValueArray(values));
            }
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public Node getNode() throws RepositoryException {
        return this.getSession().getNodeByUUID(this.getString());
    }

    public long getLength() throws RepositoryException {
        try {
            return this.remote.getLength();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public long[] getLengths() throws RepositoryException {
        try {
            return this.remote.getLengths();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public PropertyDefinition getDefinition() throws RepositoryException {
        try {
            return this.getFactory().getPropertyDef(this.remote.getDefinition());
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public int getType() throws RepositoryException {
        try {
            return this.remote.getType();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }
}

