/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.event.mouse;

import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.SatelliteVisualizationViewer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.SatelliteGraphViewer;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.event.mouse.VisualGraphSatelliteAbstractGraphMousePlugin;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;

public class VisualGraphSatelliteTranslatingGraphMousePlugin<V extends VisualVertex, E extends VisualEdge<V>>
extends VisualGraphSatelliteAbstractGraphMousePlugin<V, E> {
    private boolean didDrag;

    public VisualGraphSatelliteTranslatingGraphMousePlugin() {
        super(16);
        this.cursor = Cursor.getPredefinedCursor(13);
    }

    @Override
    protected boolean shouldShowCursor(MouseEvent e) {
        return this.isInSatelliteLensArea(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.checkModifiers(e)) {
            return;
        }
        if (!this.isHandlingMouseEvents) {
            return;
        }
        this.didDrag = true;
        e.consume();
        VisualizationViewer satelliteViewer = (VisualizationViewer)e.getSource();
        VisualizationViewer viewMaster = ((SatelliteVisualizationViewer)satelliteViewer).getMaster();
        MutableTransformer modelTransformerMaster = viewMaster.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT);
        Point2D transformedPoint = this.getDeltaForViewSpacePointsInLayoutSpace(e.getPoint(), this.down, satelliteViewer);
        this.down = e.getPoint();
        modelTransformerMaster.translate(transformedPoint.getX(), transformedPoint.getY());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.isHandlingMouseEvents) {
            e.consume();
        }
        if (this.isInSatelliteLensArea(e)) {
            this.installCursor(this.cursor, e);
            e.consume();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.isHandlingMouseEvents) {
            return;
        }
        e.consume();
        this.resetState();
        this.moveMasterViewerToMousePoint(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.checkModifiers(e)) {
            return;
        }
        if (!this.isInSatelliteLensArea(e)) {
            return;
        }
        this.isHandlingMouseEvents = true;
        this.down = e.getPoint();
        e.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.isHandlingMouseEvents) {
            return;
        }
        if (!this.didDrag) {
            return;
        }
        e.consume();
        this.resetState();
        this.didDrag = false;
        this.down = null;
        SatelliteGraphViewer satelliteViewer = this.getSatelliteGraphViewer(e);
        GraphViewer viewMaster = this.getGraphViewer(e);
        Shape satelliteLens = this.getSatelliteLensInSatelliteViewSpace(satelliteViewer, viewMaster);
        Point adjustedLensPointInViewSpace = this.getLensPointAdjustedForSatelliteBounds((VisualizationViewer<V, E>)satelliteViewer, satelliteLens);
        Rectangle lensBounds = satelliteLens.getBounds();
        Point currentLensPointInViewSpace = lensBounds.getLocation();
        if (!this.shouldAdjustLensPoint(currentLensPointInViewSpace, adjustedLensPointInViewSpace, lensBounds.getSize())) {
            return;
        }
        Point2D transformedPoint = this.getDeltaForViewSpacePointsInLayoutSpace(adjustedLensPointInViewSpace, currentLensPointInViewSpace, (VisualizationViewer<V, E>)satelliteViewer);
        MutableTransformer modelTransformerMaster = viewMaster.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT);
        modelTransformerMaster.translate(transformedPoint.getX(), transformedPoint.getY());
    }

    private boolean shouldAdjustLensPoint(Point currentLensPoint, Point adjustedLensPoint, Dimension size) {
        if (adjustedLensPoint.equals(currentLensPoint)) {
            return false;
        }
        int x1 = currentLensPoint.x;
        int x2 = adjustedLensPoint.x;
        int xDifference = Math.max(x1, x2) - Math.min(x1, x2);
        if ((double)xDifference > (double)size.width * 0.66) {
            return true;
        }
        int y1 = currentLensPoint.y;
        int y2 = adjustedLensPoint.y;
        int yDifference = Math.max(y1, y2) - Math.min(y1, y2);
        return (double)yDifference > (double)size.height * 0.66;
    }

    private Point getLensPointAdjustedForSatelliteBounds(VisualizationViewer<V, E> satelliteViewer, Shape satelliteLens) {
        Rectangle bounds = satelliteLens.getBounds();
        Point location = bounds.getLocation();
        location = SwingUtilities.convertPoint(satelliteViewer, location, satelliteViewer.getParent());
        bounds.setLocation(location);
        Rectangle satelliteBounds = satelliteViewer.getBounds();
        Rectangle lensBounds = this.moveRectangleCompletelyOntoOtherRectangle(bounds, satelliteBounds.getBounds());
        Point lensPointRelativeToSatellite = SwingUtilities.convertPoint(satelliteViewer.getParent(), lensBounds.getLocation(), satelliteViewer);
        return lensPointRelativeToSatellite;
    }

    private Rectangle moveRectangleCompletelyOntoOtherRectangle(Rectangle moveeRectangle, Rectangle destinationRectangle) {
        Rectangle newRectangle = new Rectangle(moveeRectangle);
        newRectangle.x = Math.min(newRectangle.x, destinationRectangle.x + destinationRectangle.width - newRectangle.width - 1);
        newRectangle.x = Math.max(newRectangle.x, destinationRectangle.x + 1);
        newRectangle.y = Math.min(newRectangle.y, destinationRectangle.y + destinationRectangle.height - newRectangle.height - 1);
        newRectangle.y = Math.max(newRectangle.y, destinationRectangle.y + 1);
        return newRectangle;
    }

    private Point2D getDeltaForViewSpacePointsInLayoutSpace(Point2D newPointInViewSpace, Point2D currentPointInViewSpace, VisualizationViewer<V, E> viewer) {
        RenderContext renderContext = viewer.getRenderContext();
        MultiLayerTransformer multiLayerTransformer = renderContext.getMultiLayerTransformer();
        Point2D currentPointInLayoutSpace = multiLayerTransformer.inverseTransform(currentPointInViewSpace);
        Point2D newPointInLayoutSpace = multiLayerTransformer.inverseTransform(newPointInViewSpace);
        float dx = (float)(currentPointInLayoutSpace.getX() - newPointInLayoutSpace.getX());
        float dy = (float)(currentPointInLayoutSpace.getY() - newPointInLayoutSpace.getY());
        return new Point2D.Double(dx, dy);
    }
}

