/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.scala;

import com.google.common.collect.ImmutableList;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.tasks.scala.ScalaCompilerFactory;
import org.gradle.api.internal.tasks.scala.ScalaJavaJointCompileSpec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.scala.ScalaCompileOptions;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.internal.classloader.ClasspathHasher;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.scala.tasks.AbstractScalaCompile;
import org.gradle.language.scala.tasks.BaseScalaCompileOptions;
import org.gradle.process.internal.JavaForkOptionsFactory;
import org.gradle.process.internal.worker.child.WorkerDirectoryProvider;
import org.gradle.workers.internal.ActionExecutionSpecFactory;
import org.gradle.workers.internal.WorkerDaemonFactory;

@CacheableTask
public class ScalaCompile
extends AbstractScalaCompile {
    private FileCollection scalaClasspath;
    private FileCollection zincClasspath;
    private FileCollection scalaCompilerPlugins;
    private Compiler<ScalaJavaJointCompileSpec> compiler;

    @Inject
    public ScalaCompile() {
        super((BaseScalaCompileOptions)new ScalaCompileOptions());
    }

    @Nested
    public ScalaCompileOptions getScalaCompileOptions() {
        return (ScalaCompileOptions)super.getScalaCompileOptions();
    }

    @Classpath
    public FileCollection getScalaClasspath() {
        return this.scalaClasspath;
    }

    public void setScalaClasspath(FileCollection scalaClasspath) {
        this.scalaClasspath = scalaClasspath;
    }

    @Classpath
    @Incubating
    public FileCollection getScalaCompilerPlugins() {
        return this.scalaCompilerPlugins;
    }

    @Incubating
    public void setScalaCompilerPlugins(FileCollection scalaCompilerPlugins) {
        this.scalaCompilerPlugins = scalaCompilerPlugins;
    }

    protected ScalaJavaJointCompileSpec createSpec() {
        ScalaJavaJointCompileSpec spec = super.createSpec();
        if (this.getScalaCompilerPlugins() != null) {
            spec.setScalaCompilerPlugins((Iterable)ImmutableList.copyOf((Iterable)this.getScalaCompilerPlugins()));
        }
        return spec;
    }

    @Classpath
    public FileCollection getZincClasspath() {
        return this.zincClasspath;
    }

    public void setZincClasspath(FileCollection zincClasspath) {
        this.zincClasspath = zincClasspath;
    }

    public void setCompiler(Compiler<ScalaJavaJointCompileSpec> compiler) {
        this.compiler = compiler;
    }

    protected Compiler<ScalaJavaJointCompileSpec> getCompiler(ScalaJavaJointCompileSpec spec) {
        this.assertScalaClasspathIsNonEmpty();
        if (this.compiler == null) {
            WorkerDaemonFactory workerDaemonFactory = (WorkerDaemonFactory)this.getServices().get(WorkerDaemonFactory.class);
            JavaForkOptionsFactory forkOptionsFactory = (JavaForkOptionsFactory)this.getServices().get(JavaForkOptionsFactory.class);
            ClassPathRegistry classPathRegistry = (ClassPathRegistry)this.getServices().get(ClassPathRegistry.class);
            ClassLoaderRegistry classLoaderRegistry = (ClassLoaderRegistry)this.getServices().get(ClassLoaderRegistry.class);
            ActionExecutionSpecFactory actionExecutionSpecFactory = (ActionExecutionSpecFactory)this.getServices().get(ActionExecutionSpecFactory.class);
            ScalaCompilerFactory scalaCompilerFactory = new ScalaCompilerFactory(((WorkerDirectoryProvider)this.getServices().get(WorkerDirectoryProvider.class)).getWorkingDirectory(), workerDaemonFactory, this.getScalaClasspath(), this.getZincClasspath(), forkOptionsFactory, classPathRegistry, classLoaderRegistry, actionExecutionSpecFactory, (ClasspathHasher)this.getServices().get(ClasspathHasher.class));
            this.compiler = scalaCompilerFactory.newCompiler(spec);
        }
        return this.compiler;
    }

    protected void assertScalaClasspathIsNonEmpty() {
        if (this.getScalaClasspath().isEmpty()) {
            throw new InvalidUserDataException("'" + this.getName() + ".scalaClasspath' must not be empty. If a Scala compile dependency is provided, the 'scala-base' plugin will attempt to configure 'scalaClasspath' automatically. Alternatively, you may configure 'scalaClasspath' explicitly.");
        }
    }
}

