/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.registry;

import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.api.internal.resolve.DefaultProjectModelResolver;
import org.gradle.api.internal.resolve.ProjectModelResolver;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.scopes.AbstractPluginServiceRegistry;
import org.gradle.model.internal.inspect.MethodModelRuleExtractor;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaAspectExtractionStrategy;
import org.gradle.platform.base.internal.VariantAspectExtractionStrategy;
import org.gradle.platform.base.internal.registry.BinaryTasksModelRuleExtractor;
import org.gradle.platform.base.internal.registry.ComponentBinariesModelRuleExtractor;
import org.gradle.platform.base.internal.registry.ComponentTypeModelRuleExtractor;

public class ComponentModelBaseServiceRegistry
extends AbstractPluginServiceRegistry {
    public void registerGlobalServices(ServiceRegistration registration) {
        registration.addProvider((Object)new GlobalScopeServices());
    }

    public void registerBuildServices(ServiceRegistration registration) {
        registration.addProvider((Object)new BuildScopeServices());
    }

    private static class GlobalScopeServices {
        private GlobalScopeServices() {
        }

        MethodModelRuleExtractor createComponentModelPluginInspector(ModelSchemaStore schemaStore) {
            return new ComponentTypeModelRuleExtractor(schemaStore);
        }

        MethodModelRuleExtractor createComponentBinariesPluginInspector() {
            return new ComponentBinariesModelRuleExtractor();
        }

        MethodModelRuleExtractor createBinaryTaskPluginInspector() {
            return new BinaryTasksModelRuleExtractor();
        }

        ModelSchemaAspectExtractionStrategy createVariantAspectExtractionStrategy() {
            return new VariantAspectExtractionStrategy();
        }
    }

    private static class BuildScopeServices {
        private BuildScopeServices() {
        }

        ProjectModelResolver createProjectLocator(ProjectRegistry<ProjectInternal> projectRegistry) {
            return new DefaultProjectModelResolver(projectRegistry);
        }
    }
}

