/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import net.i2p.util.LogManager;
import net.i2p.util.LogRecord;
import net.i2p.util.LogWriter;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SecureFileOutputStream;

class FileLogWriter
extends LogWriter {
    private volatile Writer _currentOut;
    private int _rotationNum = -1;
    private File _currentFile;
    private long _numBytesInCurrentFile;
    private static final int MAX_DISKFULL_MESSAGES = 8;
    private int _diskFullMessageCount;

    public FileLogWriter(LogManager manager) {
        super(manager);
    }

    @Override
    public synchronized String currentFile() {
        if (this._currentFile != null) {
            return this._currentFile.getAbsolutePath();
        }
        String rv = this.getNextFile().getAbsolutePath();
        this._rotationNum = -1;
        return rv;
    }

    @Override
    protected void writeRecord(LogRecord rec, String formatted) {
        this.writeRecord(rec.getPriority(), formatted);
    }

    @Override
    protected synchronized void writeRecord(int priority, String val) {
        block7: {
            if (val == null) {
                return;
            }
            if (this._currentOut == null) {
                this.rotateFile();
                if (this._currentOut == null) {
                    return;
                }
            }
            try {
                this._currentOut.write(val);
                this._numBytesInCurrentFile += (long)val.length();
            }
            catch (Throwable t) {
                if (!this._write) {
                    return;
                }
                if (++this._diskFullMessageCount >= 8) break block7;
                System.err.println("Error writing log, disk full? " + t);
            }
        }
        if (this._numBytesInCurrentFile >= (long)(this._manager.getFileSize() - 1024)) {
            this.rotateFile();
        }
    }

    @Override
    protected void flushWriter() {
        block3: {
            try {
                if (this._currentOut != null) {
                    this._currentOut.flush();
                }
            }
            catch (IOException ioe) {
                if (!this._write || ++this._diskFullMessageCount >= 8) break block3;
                System.err.println("Error writing the router log - disk full? " + ioe);
            }
        }
    }

    @Override
    protected void closeWriter() {
        Writer out = this._currentOut;
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void rotateFile() {
        block5: {
            File f;
            this._currentFile = f = this.getNextFile();
            this._numBytesInCurrentFile = 0L;
            File parent = f.getParentFile();
            if (parent != null) {
                SecureDirectory sd;
                boolean ok;
                if (!parent.exists() && !(ok = ((File)(sd = new SecureDirectory(parent.getAbsolutePath()))).mkdirs())) {
                    System.err.println("Unable to create the parent directory: " + parent.getAbsolutePath());
                }
                if (!parent.isDirectory()) {
                    System.err.println("Cannot put the logs in a subdirectory of a plain file: " + f.getAbsolutePath());
                }
            }
            this.closeWriter();
            try {
                this._currentOut = new BufferedWriter(new OutputStreamWriter((OutputStream)new SecureFileOutputStream(f), "UTF-8"));
            }
            catch (IOException ioe) {
                if (++this._diskFullMessageCount >= 8) break block5;
                System.err.println("Error creating log file [" + f.getAbsolutePath() + "]" + ioe);
            }
        }
    }

    private File getNextFile() {
        String pattern = this._manager.getBaseLogfilename();
        File f = new File(pattern);
        File base = null;
        if (!f.isAbsolute()) {
            base = this._manager.getContext().getLogDir();
        }
        if (pattern.indexOf(35) < 0 && pattern.indexOf(64) <= 0) {
            if (base != null) {
                return new File(base, pattern);
            }
            return f;
        }
        int max = this._manager.getRotationLimit();
        if (this._rotationNum == -1) {
            return this.getFirstFile(base, pattern, max);
        }
        ++this._rotationNum;
        if (this._rotationNum > max) {
            this._rotationNum = 0;
        }
        String newf = FileLogWriter.replace(pattern, this._rotationNum);
        if (base != null) {
            return new File(base, newf);
        }
        return new File(newf);
    }

    private File getFirstFile(File base, String pattern, int max) {
        for (int i = 0; i < max; ++i) {
            File f = base != null ? new File(base, FileLogWriter.replace(pattern, i)) : new File(FileLogWriter.replace(pattern, i));
            if (f.exists()) continue;
            this._rotationNum = i;
            return f;
        }
        File oldest = null;
        for (int i = 0; i < max; ++i) {
            File f = base != null ? new File(base, FileLogWriter.replace(pattern, i)) : new File(FileLogWriter.replace(pattern, i));
            if (oldest == null) {
                oldest = f;
                continue;
            }
            if (f.lastModified() >= oldest.lastModified()) continue;
            this._rotationNum = i;
            oldest = f;
        }
        return oldest;
    }

    private static final String replace(String pattern, int num) {
        char[] c = pattern.toCharArray();
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] != '#' && c[i] != '@') {
                buf.append(c[i]);
                continue;
            }
            buf.append(num);
        }
        return buf.toString();
    }
}

