/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.health;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.health.HealthCheckService;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.concurrent.PeriodicRunnable;
import org.jitsi.utils.concurrent.RecurringRunnableExecutor;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000 12\u00020\u00012\u00020\u0002:\u00011BO\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0004\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010-\u001a\n\u0018\u00010\u001bj\u0004\u0018\u0001`\u001cH\u0016J\b\u0010.\u001a\u00020\fH\u0016J\u0006\u0010/\u001a\u00020\fJ\u0006\u00100\u001a\u00020\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0016\u0010\u001a\u001a\n\u0018\u00010\u001bj\u0004\u0018\u0001`\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0015\"\u0004\b#\u0010\u0017R\u0016\u0010$\u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0015\"\u0004\b*\u0010\u0017R\u001a\u0010\u0005\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0015\"\u0004\b,\u0010\u0017\u00a8\u00062"}, d2={"Lorg/jitsi/health/HealthChecker;", "Lorg/jitsi/health/HealthCheckService;", "Lorg/jitsi/utils/concurrent/PeriodicRunnable;", "interval", "Ljava/time/Duration;", "timeout", "maxCheckDuration", "stickyFailures", "", "stickyFailuresGracePeriod", "healthCheckFunc", "Lkotlin/Function0;", "", "clock", "Ljava/time/Clock;", "(Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;ZLjava/time/Duration;Lkotlin/jvm/functions/Function0;Ljava/time/Clock;)V", "executor", "Lorg/jitsi/utils/concurrent/RecurringRunnableExecutor;", "hasFailed", "<set-?>", "getInterval", "()Ljava/time/Duration;", "setInterval", "(Ljava/time/Duration;)V", "interval$delegate", "Lkotlin/properties/ReadWriteProperty;", "lastResult", "Ljava/lang/Exception;", "Lkotlin/Exception;", "lastResultTime", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "logger", "Lorg/jitsi/utils/logging2/Logger;", "getMaxCheckDuration", "setMaxCheckDuration", "serviceStartTime", "getStickyFailures", "()Z", "setStickyFailures", "(Z)V", "getStickyFailuresGracePeriod", "setStickyFailuresGracePeriod", "getTimeout", "setTimeout", "getResult", "run", "start", "stop", "Companion", "jicoco"})
public final class HealthChecker
extends PeriodicRunnable
implements HealthCheckService {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private Duration timeout;
    @NotNull
    private Duration maxCheckDuration;
    private boolean stickyFailures;
    @NotNull
    private Duration stickyFailuresGracePeriod;
    @NotNull
    private final Function0<Unit> healthCheckFunc;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Logger logger;
    @Nullable
    private RecurringRunnableExecutor executor;
    @Nullable
    private Exception lastResult;
    private Instant lastResultTime;
    private Instant serviceStartTime;
    private boolean hasFailed;
    @NotNull
    private final ReadWriteProperty interval$delegate;
    @NotNull
    private static final Duration stickyFailuresGracePeriodDefault;

    public HealthChecker(@NotNull Duration interval, @NotNull Duration timeout, @NotNull Duration maxCheckDuration, boolean stickyFailures, @NotNull Duration stickyFailuresGracePeriod, @NotNull Function0<Unit> healthCheckFunc, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(interval, "interval");
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        Intrinsics.checkNotNullParameter(maxCheckDuration, "maxCheckDuration");
        Intrinsics.checkNotNullParameter(stickyFailuresGracePeriod, "stickyFailuresGracePeriod");
        Intrinsics.checkNotNullParameter(healthCheckFunc, "healthCheckFunc");
        Intrinsics.checkNotNullParameter(clock, "clock");
        super(interval.toMillis());
        this.timeout = timeout;
        this.maxCheckDuration = maxCheckDuration;
        this.stickyFailures = stickyFailures;
        this.stickyFailuresGracePeriod = stickyFailuresGracePeriod;
        this.healthCheckFunc = healthCheckFunc;
        this.clock = clock;
        this.logger = new LoggerImpl(this.getClass().getName());
        this.lastResultTime = this.clock.instant();
        this.serviceStartTime = Instant.MAX;
        Delegates this_$iv = Delegates.INSTANCE;
        boolean $i$f$observable = false;
        this.interval$delegate = new ObservableProperty<Duration>((Object)interval, this){
            final /* synthetic */ HealthChecker this$0;
            {
                this.this$0 = healthChecker;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                void newValue2;
                Intrinsics.checkNotNullParameter(property, "property");
                Duration duration = (Duration)newValue;
                Duration cfr_ignored_0 = (Duration)oldValue;
                boolean bl = false;
                this.this$0.setPeriod(newValue2.toMillis());
            }
        };
    }

    public /* synthetic */ HealthChecker(Duration duration, Duration duration2, Duration duration3, boolean bl, Duration duration4, Function0 function0, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            duration = DurationKt.getSecs(10);
        }
        if ((n & 2) != 0) {
            duration2 = DurationKt.getSecs(30);
        }
        if ((n & 4) != 0) {
            duration3 = DurationKt.getSecs(3);
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            duration4 = stickyFailuresGracePeriodDefault;
        }
        if ((n & 0x40) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue(clock2, "systemUTC()");
            clock = clock2;
        }
        this(duration, duration2, duration3, bl, duration4, function0, clock);
    }

    @NotNull
    public final Duration getTimeout() {
        return this.timeout;
    }

    public final void setTimeout(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter(duration, "<set-?>");
        this.timeout = duration;
    }

    @NotNull
    public final Duration getMaxCheckDuration() {
        return this.maxCheckDuration;
    }

    public final void setMaxCheckDuration(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter(duration, "<set-?>");
        this.maxCheckDuration = duration;
    }

    public final boolean getStickyFailures() {
        return this.stickyFailures;
    }

    public final void setStickyFailures(boolean bl) {
        this.stickyFailures = bl;
    }

    @NotNull
    public final Duration getStickyFailuresGracePeriod() {
        return this.stickyFailuresGracePeriod;
    }

    public final void setStickyFailuresGracePeriod(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter(duration, "<set-?>");
        this.stickyFailuresGracePeriod = duration;
    }

    @NotNull
    public final Duration getInterval() {
        return (Duration)this.interval$delegate.getValue(this, $$delegatedProperties[0]);
    }

    public final void setInterval(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter(duration, "<set-?>");
        this.interval$delegate.setValue(this, $$delegatedProperties[0], duration);
    }

    @Override
    @Nullable
    public Exception getResult() {
        Duration duration = Duration.between(this.lastResultTime, this.clock.instant());
        Intrinsics.checkNotNullExpressionValue(duration, "between(lastResultTime, clock.instant())");
        Duration timeSinceLastResult = duration;
        if (timeSinceLastResult.compareTo(this.timeout) > 0) {
            return new Exception("No health checks performed recently, the last result was " + timeSinceLastResult + " ago.");
        }
        return this.lastResult;
    }

    public final void start() {
        if (this.executor == null) {
            this.executor = new RecurringRunnableExecutor(this.getClass().getName());
        }
        RecurringRunnableExecutor recurringRunnableExecutor = this.executor;
        Intrinsics.checkNotNull(recurringRunnableExecutor);
        recurringRunnableExecutor.registerRecurringRunnable(this);
        this.logger.info("Started with interval=" + this.getPeriod() + ", timeout=" + this.timeout + ", maxDuration=" + this.maxCheckDuration + ", stickyFailures=" + this.stickyFailures + ".");
    }

    public final void stop() throws Exception {
        RecurringRunnableExecutor recurringRunnableExecutor = this.executor;
        if (recurringRunnableExecutor != null) {
            RecurringRunnableExecutor recurringRunnableExecutor2;
            RecurringRunnableExecutor $this$stop_u24lambda_u2d1 = recurringRunnableExecutor2 = recurringRunnableExecutor;
            boolean bl = false;
            $this$stop_u24lambda_u2d1.deRegisterRecurringRunnable(this);
            $this$stop_u24lambda_u2d1.close();
        }
        this.executor = null;
        this.logger.info("Stopped");
    }

    @Override
    public void run() {
        Exception exception;
        Instant checkStart;
        block7: {
            super.run();
            checkStart = this.clock.instant();
            exception = null;
            try {
                this.healthCheckFunc.invoke();
            }
            catch (Exception e) {
                exception = e;
                Instant now = this.clock.instant();
                Duration timeSinceStart = Duration.between(this.serviceStartTime, now);
                if (timeSinceStart.compareTo(this.stickyFailuresGracePeriod) <= 0) break block7;
                this.hasFailed = true;
            }
        }
        this.lastResultTime = this.clock.instant();
        Duration checkDuration = Duration.between(checkStart, this.lastResultTime);
        if (checkDuration.compareTo(this.maxCheckDuration) > 0) {
            exception = new Exception("Performing a health check took too long: " + checkDuration);
        }
        Exception previousResult = this.lastResult;
        Exception exception2 = this.lastResult = this.stickyFailures && this.hasFailed && exception == null ? new Exception("Sticky failure.") : exception;
        if (exception == null) {
            String message = "Performed a successful health check in " + checkDuration + ". Sticky failure: " + (this.stickyFailures && this.hasFailed);
            if (previousResult == null) {
                this.logger.debug(message);
            } else {
                this.logger.info(message);
            }
        } else {
            this.logger.error("Health check failed in " + checkDuration + ":", exception);
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(HealthChecker.class, "interval", "getInterval()Ljava/time/Duration;", 0))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        Duration duration = Duration.ofMinutes(5L);
        Intrinsics.checkNotNullExpressionValue(duration, "ofMinutes(5)");
        stickyFailuresGracePeriodDefault = duration;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jitsi/health/HealthChecker$Companion;", "", "()V", "stickyFailuresGracePeriodDefault", "Ljava/time/Duration;", "getStickyFailuresGracePeriodDefault", "()Ljava/time/Duration;", "jicoco"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Duration getStickyFailuresGracePeriodDefault() {
            return stickyFailuresGracePeriodDefault;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

