/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.protocol.xmpp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jitsi.impl.protocol.xmpp.JingleStats;
import org.jitsi.jicofo.conference.source.ConferenceSourceMap;
import org.jitsi.jicofo.xmpp.JingleUtilsKt;
import org.jitsi.jicofo.xmpp.UtilKt;
import org.jitsi.protocol.xmpp.JingleRequestHandler;
import org.jitsi.protocol.xmpp.JingleSession;
import org.jitsi.protocol.xmpp.OperationSetJingle;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.xmpp.extensions.colibri.SourcePacketExtension;
import org.jitsi.xmpp.extensions.jingle.ContentPacketExtension;
import org.jitsi.xmpp.extensions.jingle.GroupPacketExtension;
import org.jitsi.xmpp.extensions.jingle.JingleAction;
import org.jitsi.xmpp.extensions.jingle.JingleIQ;
import org.jitsi.xmpp.extensions.jingle.JinglePacketFactory;
import org.jitsi.xmpp.extensions.jingle.Reason;
import org.jitsi.xmpp.extensions.jingle.RtpDescriptionPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SourceGroupPacketExtension;
import org.jitsi.xmpp.extensions.jitsimeet.JsonMessageExtension;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.json.simple.JSONObject;
import org.jxmpp.jid.Jid;

public abstract class AbstractOperationSetJingle
extends AbstractIqRequestHandler
implements OperationSetJingle {
    private static final Logger logger = new LoggerImpl(AbstractOperationSetJingle.class.getName());
    private static final JingleStats stats = new JingleStats();
    protected final Map<String, JingleSession> sessions = new ConcurrentHashMap<String, JingleSession>();

    public static JSONObject getStats() {
        return stats.toJson();
    }

    protected AbstractOperationSetJingle() {
        super("jingle", "urn:xmpp:jingle:1", IQ.Type.set, IQRequestHandler.Mode.sync);
    }

    @Override
    public IQ handleIQRequest(IQ iqRequest) {
        JingleIQ packet = (JingleIQ)iqRequest;
        JingleSession session = this.getSession(packet.getSID());
        if (session == null) {
            logger.warn("No session found for SID " + packet.getSID());
            return IQ.createErrorResponse((IQ)packet, StanzaError.getBuilder(StanzaError.Condition.bad_request).build());
        }
        return this.processJingleIQ(packet);
    }

    @Override
    public Jid getOurJID() {
        return this.getConnection().getUser();
    }

    protected abstract AbstractXMPPConnection getConnection();

    public JingleSession getSession(String sid) {
        return this.sessions.get(sid);
    }

    @Override
    public boolean initiateSession(Jid to, List<ContentPacketExtension> contents, List<ExtensionElement> additionalExtensions, JingleRequestHandler requestHandler, ConferenceSourceMap sources, boolean encodeSourcesAsJson) throws SmackException.NotConnectedException {
        JsonMessageExtension jsonSources = null;
        if (encodeSourcesAsJson) {
            jsonSources = this.encodeSourcesAsJson(sources);
        } else {
            contents = this.encodeSources(sources, contents);
        }
        JingleIQ inviteIQ = JingleUtilsKt.createSessionInitiate(this.getOurJID(), to, contents);
        String sid = inviteIQ.getSID();
        JingleSession session = new JingleSession(sid, to, requestHandler);
        inviteIQ.addExtension(GroupPacketExtension.createBundleGroup(inviteIQ.getContentList()));
        additionalExtensions.forEach(inviteIQ::addExtension);
        if (jsonSources != null) {
            inviteIQ.addExtension(jsonSources);
        }
        this.sessions.put(sid, session);
        IQ reply = UtilKt.sendIqAndGetResponse(this.getConnection(), inviteIQ);
        stats.stanzaSent(inviteIQ.getAction());
        if (reply == null || IQ.Type.result.equals((Object)reply.getType())) {
            return true;
        }
        logger.error("Unexpected response to 'session-initiate' from " + session.getAddress() + ": " + reply.toXML());
        return false;
    }

    @Override
    public boolean replaceTransport(@NotNull JingleSession session, List<ContentPacketExtension> contents, List<ExtensionElement> additionalExtensions, ConferenceSourceMap sources, boolean encodeSourcesAsJson) throws SmackException.NotConnectedException {
        Jid address = session.getAddress();
        if (!this.sessions.containsValue(session)) {
            throw new IllegalStateException("Session does not exist for: " + address);
        }
        logger.info("RE-INVITE PEER: " + address);
        JsonMessageExtension jsonSources = null;
        if (encodeSourcesAsJson) {
            jsonSources = this.encodeSourcesAsJson(sources);
        } else {
            contents = this.encodeSources(sources, contents);
        }
        JingleIQ jingleIQ = JingleUtilsKt.createTransportReplace(this.getOurJID(), session, contents);
        jingleIQ.addExtension(GroupPacketExtension.createBundleGroup(jingleIQ.getContentList()));
        additionalExtensions.forEach(jingleIQ::addExtension);
        if (jsonSources != null) {
            jingleIQ.addExtension(jsonSources);
        }
        IQ reply = UtilKt.sendIqAndGetResponse(this.getConnection(), jingleIQ);
        stats.stanzaSent(jingleIQ.getAction());
        if (reply == null || IQ.Type.result.equals((Object)reply.getType())) {
            return true;
        }
        logger.error("Unexpected response to 'transport-replace' from " + session.getAddress() + ": " + reply.toXML());
        return false;
    }

    private JsonMessageExtension encodeSourcesAsJson(ConferenceSourceMap sources) {
        return new JsonMessageExtension("{\"sources\":" + sources.compactJson() + "}");
    }

    private List<ContentPacketExtension> encodeSources(ConferenceSourceMap sources, List<ContentPacketExtension> contents) {
        ContentPacketExtension audioContent = contents.stream().filter(c -> c.getName().equals("audio")).findFirst().orElse(null);
        ContentPacketExtension videoContent = contents.stream().filter(c -> c.getName().equals("video")).findFirst().orElse(null);
        ArrayList<ContentPacketExtension> ret = new ArrayList<ContentPacketExtension>();
        if (audioContent != null) {
            ret.add(audioContent);
        }
        if (videoContent != null) {
            ret.add(videoContent);
        }
        List<SourcePacketExtension> audioSourceExtensions = sources.createSourcePacketExtensions(MediaType.AUDIO);
        List<SourceGroupPacketExtension> audioSsrcGroupExtensions = sources.createSourceGroupPacketExtensions(MediaType.AUDIO);
        List<SourcePacketExtension> videoSourceExtensions = sources.createSourcePacketExtensions(MediaType.VIDEO);
        List<SourceGroupPacketExtension> videoSsrcGroupExtensions = sources.createSourceGroupPacketExtensions(MediaType.VIDEO);
        if (!audioSourceExtensions.isEmpty() || !audioSsrcGroupExtensions.isEmpty()) {
            RtpDescriptionPacketExtension audioDescription;
            if (audioContent == null) {
                audioContent = new ContentPacketExtension();
                audioContent.setName("audio");
                ret.add(audioContent);
            }
            if ((audioDescription = audioContent.getFirstChildOfType(RtpDescriptionPacketExtension.class)) == null) {
                audioDescription = new RtpDescriptionPacketExtension();
                audioDescription.setMedia("audio");
                audioContent.addChildExtension(audioDescription);
            }
            for (SourcePacketExtension sourcePacketExtension : audioSourceExtensions) {
                audioDescription.addChildExtension(sourcePacketExtension);
            }
            for (SourceGroupPacketExtension sourceGroupPacketExtension : audioSsrcGroupExtensions) {
                audioDescription.addChildExtension(sourceGroupPacketExtension);
            }
        }
        if (!videoSourceExtensions.isEmpty() || !videoSsrcGroupExtensions.isEmpty()) {
            RtpDescriptionPacketExtension videoDescription;
            if (videoContent == null) {
                videoContent = new ContentPacketExtension();
                videoContent.setName("video");
                ret.add(videoContent);
            }
            if ((videoDescription = videoContent.getFirstChildOfType(RtpDescriptionPacketExtension.class)) == null) {
                videoDescription = new RtpDescriptionPacketExtension();
                videoDescription.setMedia("video");
                videoContent.addChildExtension(videoDescription);
            }
            for (SourcePacketExtension sourcePacketExtension : videoSourceExtensions) {
                videoDescription.addChildExtension(sourcePacketExtension);
            }
            for (SourceGroupPacketExtension sourceGroupPacketExtension : videoSsrcGroupExtensions) {
                videoDescription.addChildExtension(sourceGroupPacketExtension);
            }
        }
        return ret;
    }

    protected IQ processJingleIQ(JingleIQ iq) {
        JingleSession session = this.getSession(iq.getSID());
        JingleAction action = iq.getAction();
        if (action == null) {
            return IQ.createErrorResponse((IQ)iq, StanzaError.getBuilder(StanzaError.Condition.bad_request).build());
        }
        stats.stanzaReceived(action);
        if (session == null) {
            logger.warn("Action: " + action + ", no session found for SID " + iq.getSID());
            return IQ.createErrorResponse((IQ)iq, StanzaError.getBuilder(StanzaError.Condition.item_not_found).build());
        }
        JingleRequestHandler requestHandler = session.getRequestHandler();
        StanzaError error = null;
        switch (action) {
            case SESSION_ACCEPT: {
                error = requestHandler.onSessionAccept(session, iq.getContentList());
                break;
            }
            case SESSION_INFO: {
                error = requestHandler.onSessionInfo(session, iq);
                break;
            }
            case SESSION_TERMINATE: {
                error = requestHandler.onSessionTerminate(session, iq);
                break;
            }
            case TRANSPORT_ACCEPT: {
                error = requestHandler.onTransportAccept(session, iq.getContentList());
                break;
            }
            case TRANSPORT_INFO: {
                requestHandler.onTransportInfo(session, iq.getContentList());
                break;
            }
            case TRANSPORT_REJECT: {
                requestHandler.onTransportReject(session, iq);
                break;
            }
            case ADDSOURCE: 
            case SOURCEADD: {
                error = requestHandler.onAddSource(session, iq.getContentList());
                break;
            }
            case REMOVESOURCE: 
            case SOURCEREMOVE: {
                error = requestHandler.onRemoveSource(session, iq.getContentList());
                break;
            }
            default: {
                error = StanzaError.getBuilder(StanzaError.Condition.feature_not_implemented).build();
                logger.warn("unsupported action " + action);
            }
        }
        if (error == null) {
            return IQ.createResultIQ(iq);
        }
        return IQ.createErrorResponse((IQ)iq, error);
    }

    private JingleIQ createAddSourceIq(ConferenceSourceMap sources, JingleSession session, boolean encodeSourcesAsJson) {
        JingleIQ addSourceIq = new JingleIQ(JingleAction.SOURCEADD, session.getSessionID());
        addSourceIq.setFrom(this.getOurJID());
        addSourceIq.setType(IQ.Type.set);
        addSourceIq.setTo(session.getAddress());
        if (encodeSourcesAsJson) {
            addSourceIq.addExtension(this.encodeSourcesAsJson(sources));
        } else {
            sources.toJingle().forEach(addSourceIq::addContent);
        }
        logger.debug("Sending source-add to " + session.getAddress() + ", SID=" + session.getSessionID() + ", sources=" + sources);
        return addSourceIq;
    }

    @Override
    public void sendAddSourceIQ(ConferenceSourceMap sources, JingleSession session, boolean encodeSourcesAsJson) {
        JingleIQ addSourceIq = this.createAddSourceIq(sources, session, encodeSourcesAsJson);
        UtilKt.tryToSendStanza(this.getConnection(), addSourceIq);
        stats.stanzaSent(JingleAction.SOURCEADD);
    }

    public boolean sendAddSourceIQAndGetResult(ConferenceSourceMap sources, JingleSession session, boolean encodeSourcesAsJson) throws SmackException.NotConnectedException {
        JingleIQ addSourceIq = this.createAddSourceIq(sources, session, encodeSourcesAsJson);
        IQ reply = UtilKt.sendIqAndGetResponse(this.getConnection(), addSourceIq);
        stats.stanzaSent(JingleAction.SOURCEADD);
        if (reply == null) {
            return false;
        }
        if (IQ.Type.result.equals((Object)reply.getType())) {
            return true;
        }
        logger.error("Failed to do 'source-add' to " + session.getAddress() + ": " + reply.toXML());
        return false;
    }

    @Override
    public void sendRemoveSourceIQ(ConferenceSourceMap sourcesToRemove, JingleSession session, boolean encodeSourcesAsJson) {
        JingleIQ removeSourceIq = new JingleIQ(JingleAction.SOURCEREMOVE, session.getSessionID());
        removeSourceIq.setFrom(this.getOurJID());
        removeSourceIq.setType(IQ.Type.set);
        removeSourceIq.setTo(session.getAddress());
        if (encodeSourcesAsJson) {
            removeSourceIq.addExtension(this.encodeSourcesAsJson(sourcesToRemove));
        } else {
            sourcesToRemove.toJingle().forEach(removeSourceIq::addContent);
        }
        logger.debug("Sending source-remove to " + session.getAddress() + ", SID=" + session.getSessionID() + ", sources=" + sourcesToRemove);
        UtilKt.tryToSendStanza(this.getConnection(), removeSourceIq);
        stats.stanzaSent(JingleAction.SOURCEREMOVE);
    }

    @Override
    public void terminateHandlersSessions(JingleRequestHandler requestHandler) {
        ArrayList<JingleSession> sessions = new ArrayList<JingleSession>(this.sessions.values());
        for (JingleSession session : sessions) {
            if (session.getRequestHandler() != requestHandler) continue;
            this.terminateSession(session, Reason.GONE, null, true);
        }
    }

    @Override
    public void terminateSession(JingleSession session, Reason reason, String message, boolean sendTerminate) {
        logger.info(String.format("Terminate session: %s, reason: %s, send terminate: %s", new Object[]{session.getAddress(), reason, sendTerminate}));
        if (sendTerminate) {
            JingleIQ terminate = JinglePacketFactory.createSessionTerminate(this.getOurJID(), session.getAddress(), session.getSessionID(), reason, message);
            UtilKt.tryToSendStanza(this.getConnection(), terminate);
            stats.stanzaSent(JingleAction.SESSION_TERMINATE);
        }
        this.sessions.remove(session.getSessionID());
    }
}

