/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.protocol.xmpp.util;

import org.jetbrains.annotations.NotNull;
import org.jitsi.xmpp.extensions.jingle.CandidatePacketExtension;
import org.jitsi.xmpp.extensions.jingle.DtlsFingerprintPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceRtcpmuxPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;

public class TransportSignaling {
    public static void mergeTransportExtension(@NotNull IceUdpTransportPacketExtension dst, @NotNull IceUdpTransportPacketExtension src) {
        for (String attribute : src.getAttributeNames()) {
            dst.setAttribute(attribute, src.getAttribute(attribute));
        }
        if (src.isRtcpMux() && !dst.isRtcpMux()) {
            dst.addChildExtension(new IceRtcpmuxPacketExtension());
        }
        for (CandidatePacketExtension c : src.getCandidateList()) {
            dst.addCandidate(c);
        }
        DtlsFingerprintPacketExtension srcDtls = src.getFirstChildOfType(DtlsFingerprintPacketExtension.class);
        if (srcDtls != null) {
            DtlsFingerprintPacketExtension dstDtls = dst.getFirstChildOfType(DtlsFingerprintPacketExtension.class);
            if (dstDtls != null) {
                dst.removeChildExtension(dstDtls);
            }
            dst.addChildExtension(srcDtls);
        }
    }
}

