/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.util.Arrays;
import javax.net.ssl.SSLSessionContext;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.openssl.OpenSSL;
import org.jruby.ext.openssl.SSL;
import org.jruby.ext.openssl.SSLSocket;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class SSLSession
extends RubyObject {
    private javax.net.ssl.SSLSession sslSession;

    static void createSession(Ruby runtime, RubyModule SSL2, RubyClass OpenSSLError) {
        RubyClass Session = SSL2.defineClassUnder("Session", runtime.getObject(), (r, klass) -> new SSLSession(r, klass));
        Session.defineClassUnder("SessionError", OpenSSLError, OpenSSLError.getAllocator());
        Session.defineAnnotatedMethods(SSLSession.class);
    }

    SSLSession(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    SSLSession(Ruby runtime) {
        this(runtime, (RubyClass)SSL._SSL(runtime).getConstantAt("Session"));
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context2, IRubyObject arg) {
        Ruby runtime = context2.runtime;
        if (arg instanceof SSLSocket) {
            return this.initializeImpl((SSLSocket)arg);
        }
        throw runtime.newNotImplementedError("Session#initialize with " + arg.getMetaClass().getName());
    }

    SSLSession initializeImpl(SSLSocket socket) {
        this.sslSession = socket.sslSession();
        return this;
    }

    final javax.net.ssl.SSLSession sslSession() {
        return this.sslSession;
    }

    @JRubyMethod(name={"=="})
    public IRubyObject op_eqq(ThreadContext context2, IRubyObject other) {
        return context2.runtime.newBoolean(this.equals(other));
    }

    public boolean equals(Object other) {
        if (other instanceof SSLSession) {
            SSLSession that = (SSLSession)((Object)other);
            if (this.sslSession.getProtocol().equals(that.sslSession.getProtocol()) && Arrays.equals(this.sslSession.getId(), that.sslSession.getId())) {
                return true;
            }
        }
        return false;
    }

    public final int hashCode() {
        return 17 * this.sslSession.hashCode();
    }

    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.hashCode());
    }

    @JRubyMethod(name={"id"})
    public RubyString id(ThreadContext context2) {
        byte[] id2 = this.sslSession().getId();
        return context2.runtime.newString(new ByteList(id2));
    }

    @JRubyMethod(name={"id="})
    public IRubyObject set_id(ThreadContext context2, IRubyObject id2) {
        OpenSSL.warn(context2, "OpenSSL::SSL::Session#id= is not supported (read-only)");
        return context2.nil;
    }

    @JRubyMethod(name={"time"})
    public RubyTime time(ThreadContext context2) {
        long time2 = this.sslSession().getCreationTime();
        return RubyTime.newTime((Ruby)context2.runtime, (long)time2);
    }

    @JRubyMethod(name={"time="})
    public IRubyObject set_time(ThreadContext context2, IRubyObject time2) {
        OpenSSL.warn(context2, "OpenSSL::SSL::Session#time= is not supported (read-only)");
        return context2.nil;
    }

    @JRubyMethod(name={"timeout"})
    public IRubyObject timeout(ThreadContext context2) {
        SSLSessionContext sessionContext = this.sslSession().getSessionContext();
        if (sessionContext == null) {
            return context2.runtime.newFixnum(300);
        }
        return context2.runtime.newFixnum(sessionContext.getSessionTimeout());
    }

    @JRubyMethod(name={"timeout="})
    public IRubyObject set_timeout(ThreadContext context2, IRubyObject timeout2) {
        SSLSessionContext sessionContext = this.sslSession().getSessionContext();
        if (sessionContext == null) {
            OpenSSL.warn(context2, "WARNING: can not set OpenSSL::SSL::Session#timeout=(" + timeout2 + ") no session context");
            return context2.nil;
        }
        sessionContext.setSessionTimeout(RubyNumeric.fix2int((IRubyObject)timeout2));
        return timeout2;
    }

    public Object toJava(Class target) {
        if (javax.net.ssl.SSLSession.class == target || target.isInstance(this.sslSession)) {
            return this.sslSession;
        }
        return super.toJava(target);
    }
}

