/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * notEqual(dvec3(-1.5lf, -1.5lf, -1.5lf), dvec3(-1.5lf, -0.5lf, 0.5lf)) => bvec3(false, true, true)
 * notEqual(dvec3(-1.5lf, -0.5lf, -0.5lf), dvec3(1.5lf, -1.5lf, -0.5lf)) => bvec3(true, true, false)
 * notEqual(dvec3(-0.5lf, -0.5lf, 0.5lf), dvec3(0.5lf, 1.5lf, -1.5lf)) => bvec3(true, true, true)
 * notEqual(dvec3(0.5lf, 0.5lf, 0.5lf), dvec3(-0.5lf, 0.5lf, 1.5lf)) => bvec3(true, false, true)
 * notEqual(dvec3(1.5lf, 1.5lf, 1.5lf), dvec3(-1.5lf, -0.5lf, 0.5lf)) => bvec3(true, true, true)
 * notEqual(dvec3(1.5lf, -1.5lf, -1.5lf), dvec3(1.5lf, -1.5lf, -0.5lf)) => bvec3(false, false, true)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[all(equal(notEqual(dvec3(-1.5lf, -1.5lf, -1.5lf), dvec3(-1.5lf, -0.5lf, 0.5lf)), bvec3(false, true, true))) ? 1 : -1] array0;
  double[all(equal(notEqual(dvec3(-1.5lf, -0.5lf, -0.5lf), dvec3(1.5lf, -1.5lf, -0.5lf)), bvec3(true, true, false))) ? 1 : -1] array1;
  double[all(equal(notEqual(dvec3(-0.5lf, -0.5lf, 0.5lf), dvec3(0.5lf, 1.5lf, -1.5lf)), bvec3(true, true, true))) ? 1 : -1] array2;
  double[all(equal(notEqual(dvec3(0.5lf, 0.5lf, 0.5lf), dvec3(-0.5lf, 0.5lf, 1.5lf)), bvec3(true, false, true))) ? 1 : -1] array3;
  double[all(equal(notEqual(dvec3(1.5lf, 1.5lf, 1.5lf), dvec3(-1.5lf, -0.5lf, 0.5lf)), bvec3(true, true, true))) ? 1 : -1] array4;
  double[all(equal(notEqual(dvec3(1.5lf, -1.5lf, -1.5lf), dvec3(1.5lf, -1.5lf, -0.5lf)), bvec3(false, false, true))) ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
