/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * atan(vec3(0.0, 1e-10, -1e-10)) => vec3(0.0, 1e-10, -1e-10)
 * atan(vec3(0.1, -0.1, 1.0)) => vec3(0.09966865, -0.09966865, 0.7853982)
 * atan(vec3(-1.0, 10.0, -10.0)) => vec3(-0.7853982, 1.4711276, -1.4711276)
 * atan(vec3(10000000000.0, -10000000000.0, 0.0)) => vec3(1.5707964, -1.5707964, 0.0)
 */
#version 120

void main()
{
  float[distance(atan(vec3(0.0, 1e-10, -1e-10)), vec3(0.0, 1e-10, -1e-10)) <= 0.00017320507 ? 1 : -1] array0;
  float[distance(atan(vec3(0.1, -0.1, 1.0)), vec3(0.09966865, -0.09966865, 0.7853982)) <= 0.000798029 ? 1 : -1] array1;
  float[distance(atan(vec3(-1.0, 10.0, -10.0)), vec3(-0.7853982, 1.4711276, -1.4711276)) <= 0.0022237992 ? 1 : -1] array2;
  float[distance(atan(vec3(10000000000.0, -10000000000.0, 0.0)), vec3(1.5707964, -1.5707964, 0.0)) <= 0.0022236912 ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
