/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * min(vec3(-2.0, -0.6666667, 0.6666667), -2.0) => vec3(-2.0, -2.0, -2.0)
 * min(vec3(2.0, -2.0, -0.6666667), -2.0) => vec3(-2.0, -2.0, -2.0)
 * min(vec3(-2.0, -0.6666667, 0.6666667), -0.6666667) => vec3(-2.0, -0.6666667, -0.6666667)
 * min(vec3(2.0, -2.0, -0.6666667), -0.6666667) => vec3(-0.6666667, -2.0, -0.6666667)
 * min(vec3(-2.0, -0.6666667, 0.6666667), 0.6666667) => vec3(-2.0, -0.6666667, 0.6666667)
 * min(vec3(2.0, -2.0, -0.6666667), 0.6666667) => vec3(0.6666667, -2.0, -0.6666667)
 * min(vec3(-2.0, -0.6666667, 0.6666667), 2.0) => vec3(-2.0, -0.6666667, 0.6666667)
 * min(vec3(2.0, -2.0, -0.6666667), 2.0) => vec3(2.0, -2.0, -0.6666667)
 */
#version 120

void main()
{
  float[distance(min(vec3(-2.0, -0.6666667, 0.6666667), -2.0), vec3(-2.0, -2.0, -2.0)) <= 3.4641016e-05 ? 1 : -1] array0;
  float[distance(min(vec3(2.0, -2.0, -0.6666667), -2.0), vec3(-2.0, -2.0, -2.0)) <= 3.4641016e-05 ? 1 : -1] array1;
  float[distance(min(vec3(-2.0, -0.6666667, 0.6666667), -0.6666667), vec3(-2.0, -0.6666667, -0.6666667)) <= 2.2110831e-05 ? 1 : -1] array2;
  float[distance(min(vec3(2.0, -2.0, -0.6666667), -0.6666667), vec3(-0.6666667, -2.0, -0.6666667)) <= 2.2110831e-05 ? 1 : -1] array3;
  float[distance(min(vec3(-2.0, -0.6666667, 0.6666667), 0.6666667), vec3(-2.0, -0.6666667, 0.6666667)) <= 2.2110831e-05 ? 1 : -1] array4;
  float[distance(min(vec3(2.0, -2.0, -0.6666667), 0.6666667), vec3(0.6666667, -2.0, -0.6666667)) <= 2.2110831e-05 ? 1 : -1] array5;
  float[distance(min(vec3(-2.0, -0.6666667, 0.6666667), 2.0), vec3(-2.0, -0.6666667, 0.6666667)) <= 2.2110831e-05 ? 1 : -1] array6;
  float[distance(min(vec3(2.0, -2.0, -0.6666667), 2.0), vec3(2.0, -2.0, -0.6666667)) <= 2.9059325e-05 ? 1 : -1] array7;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
