/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec4(16, 24, -23, -25) << uvec4(16u, 24u, 23u, 25u)) => ivec4(1048576, 402653184, -192937984, -838860800)
 * (ivec4(16, 24, -23, -25) << uvec4(23u, 12u, 14u, 19u)) => ivec4(134217728, 98304, -376832, -13107200)
 * (ivec4(16, 24, 23, 25) << uvec4(16u, 24u, 23u, 25u)) => ivec4(1048576, 402653184, 192937984, 838860800)
 * (ivec4(16, 24, 23, 25) << uvec4(23u, 12u, 14u, 19u)) => ivec4(134217728, 98304, 376832, 13107200)
 * (ivec4(-23, -12, 14, 19) << uvec4(16u, 24u, 23u, 25u)) => ivec4(-1507328, -201326592, 117440512, 637534208)
 * (ivec4(-23, -12, 14, 19) << uvec4(23u, 12u, 14u, 19u)) => ivec4(-192937984, -49152, 229376, 9961472)
 * (ivec4(23, 12, 14, 19) << uvec4(16u, 24u, 23u, 25u)) => ivec4(1507328, 201326592, 117440512, 637534208)
 * (ivec4(23, 12, 14, 19) << uvec4(23u, 12u, 14u, 19u)) => ivec4(192937984, 49152, 229376, 9961472)
 */
#version 130

void main()
{
  float[all(equal((ivec4(16, 24, -23, -25) << uvec4(16u, 24u, 23u, 25u)), ivec4(1048576, 402653184, -192937984, -838860800))) ? 1 : -1] array0;
  float[all(equal((ivec4(16, 24, -23, -25) << uvec4(23u, 12u, 14u, 19u)), ivec4(134217728, 98304, -376832, -13107200))) ? 1 : -1] array1;
  float[all(equal((ivec4(16, 24, 23, 25) << uvec4(16u, 24u, 23u, 25u)), ivec4(1048576, 402653184, 192937984, 838860800))) ? 1 : -1] array2;
  float[all(equal((ivec4(16, 24, 23, 25) << uvec4(23u, 12u, 14u, 19u)), ivec4(134217728, 98304, 376832, 13107200))) ? 1 : -1] array3;
  float[all(equal((ivec4(-23, -12, 14, 19) << uvec4(16u, 24u, 23u, 25u)), ivec4(-1507328, -201326592, 117440512, 637534208))) ? 1 : -1] array4;
  float[all(equal((ivec4(-23, -12, 14, 19) << uvec4(23u, 12u, 14u, 19u)), ivec4(-192937984, -49152, 229376, 9961472))) ? 1 : -1] array5;
  float[all(equal((ivec4(23, 12, 14, 19) << uvec4(16u, 24u, 23u, 25u)), ivec4(1507328, 201326592, 117440512, 637534208))) ? 1 : -1] array6;
  float[all(equal((ivec4(23, 12, 14, 19) << uvec4(23u, 12u, 14u, 19u)), ivec4(192937984, 49152, 229376, 9961472))) ? 1 : -1] array7;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
