/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * lessThan(ivec2(-5, -5), ivec2(-5, -2)) => bvec2(false, true)
 * lessThan(ivec2(-5, -5), ivec2(-1, 0)) => bvec2(true, true)
 * lessThan(ivec2(-5, -5), ivec2(1, 2)) => bvec2(true, true)
 * lessThan(ivec2(-5, -2), ivec2(5, -5)) => bvec2(true, false)
 * lessThan(ivec2(-2, -2), ivec2(-2, -1)) => bvec2(false, true)
 * lessThan(ivec2(-2, -2), ivec2(0, 1)) => bvec2(true, true)
 * lessThan(ivec2(-2, -2), ivec2(2, 5)) => bvec2(true, true)
 * lessThan(ivec2(-1, -1), ivec2(-5, -2)) => bvec2(false, false)
 * lessThan(ivec2(-1, -1), ivec2(-1, 0)) => bvec2(false, true)
 * lessThan(ivec2(-1, -1), ivec2(1, 2)) => bvec2(true, true)
 * lessThan(ivec2(-1, 0), ivec2(5, -5)) => bvec2(true, false)
 * lessThan(ivec2(0, 0), ivec2(-2, -1)) => bvec2(false, false)
 * lessThan(ivec2(0, 0), ivec2(0, 1)) => bvec2(false, true)
 * lessThan(ivec2(0, 0), ivec2(2, 5)) => bvec2(true, true)
 * lessThan(ivec2(1, 1), ivec2(-5, -2)) => bvec2(false, false)
 * lessThan(ivec2(1, 1), ivec2(-1, 0)) => bvec2(false, false)
 * lessThan(ivec2(1, 1), ivec2(1, 2)) => bvec2(false, true)
 * lessThan(ivec2(1, 2), ivec2(5, -5)) => bvec2(true, false)
 * lessThan(ivec2(2, 2), ivec2(-2, -1)) => bvec2(false, false)
 * lessThan(ivec2(2, 2), ivec2(0, 1)) => bvec2(false, false)
 * lessThan(ivec2(2, 2), ivec2(2, 5)) => bvec2(false, true)
 * lessThan(ivec2(5, 5), ivec2(-5, -2)) => bvec2(false, false)
 * lessThan(ivec2(5, 5), ivec2(-1, 0)) => bvec2(false, false)
 * lessThan(ivec2(5, 5), ivec2(1, 2)) => bvec2(false, false)
 * lessThan(ivec2(5, -5), ivec2(5, -5)) => bvec2(false, false)
 */
#version 150

void main()
{
  float[all(equal(lessThan(ivec2(-5, -5), ivec2(-5, -2)), bvec2(false, true))) ? 1 : -1] array0;
  float[all(equal(lessThan(ivec2(-5, -5), ivec2(-1, 0)), bvec2(true, true))) ? 1 : -1] array1;
  float[all(equal(lessThan(ivec2(-5, -5), ivec2(1, 2)), bvec2(true, true))) ? 1 : -1] array2;
  float[all(equal(lessThan(ivec2(-5, -2), ivec2(5, -5)), bvec2(true, false))) ? 1 : -1] array3;
  float[all(equal(lessThan(ivec2(-2, -2), ivec2(-2, -1)), bvec2(false, true))) ? 1 : -1] array4;
  float[all(equal(lessThan(ivec2(-2, -2), ivec2(0, 1)), bvec2(true, true))) ? 1 : -1] array5;
  float[all(equal(lessThan(ivec2(-2, -2), ivec2(2, 5)), bvec2(true, true))) ? 1 : -1] array6;
  float[all(equal(lessThan(ivec2(-1, -1), ivec2(-5, -2)), bvec2(false, false))) ? 1 : -1] array7;
  float[all(equal(lessThan(ivec2(-1, -1), ivec2(-1, 0)), bvec2(false, true))) ? 1 : -1] array8;
  float[all(equal(lessThan(ivec2(-1, -1), ivec2(1, 2)), bvec2(true, true))) ? 1 : -1] array9;
  float[all(equal(lessThan(ivec2(-1, 0), ivec2(5, -5)), bvec2(true, false))) ? 1 : -1] array10;
  float[all(equal(lessThan(ivec2(0, 0), ivec2(-2, -1)), bvec2(false, false))) ? 1 : -1] array11;
  float[all(equal(lessThan(ivec2(0, 0), ivec2(0, 1)), bvec2(false, true))) ? 1 : -1] array12;
  float[all(equal(lessThan(ivec2(0, 0), ivec2(2, 5)), bvec2(true, true))) ? 1 : -1] array13;
  float[all(equal(lessThan(ivec2(1, 1), ivec2(-5, -2)), bvec2(false, false))) ? 1 : -1] array14;
  float[all(equal(lessThan(ivec2(1, 1), ivec2(-1, 0)), bvec2(false, false))) ? 1 : -1] array15;
  float[all(equal(lessThan(ivec2(1, 1), ivec2(1, 2)), bvec2(false, true))) ? 1 : -1] array16;
  float[all(equal(lessThan(ivec2(1, 2), ivec2(5, -5)), bvec2(true, false))) ? 1 : -1] array17;
  float[all(equal(lessThan(ivec2(2, 2), ivec2(-2, -1)), bvec2(false, false))) ? 1 : -1] array18;
  float[all(equal(lessThan(ivec2(2, 2), ivec2(0, 1)), bvec2(false, false))) ? 1 : -1] array19;
  float[all(equal(lessThan(ivec2(2, 2), ivec2(2, 5)), bvec2(false, true))) ? 1 : -1] array20;
  float[all(equal(lessThan(ivec2(5, 5), ivec2(-5, -2)), bvec2(false, false))) ? 1 : -1] array21;
  float[all(equal(lessThan(ivec2(5, 5), ivec2(-1, 0)), bvec2(false, false))) ? 1 : -1] array22;
  float[all(equal(lessThan(ivec2(5, 5), ivec2(1, 2)), bvec2(false, false))) ? 1 : -1] array23;
  float[all(equal(lessThan(ivec2(5, -5), ivec2(5, -5)), bvec2(false, false))) ? 1 : -1] array24;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length() + array20.length() + array21.length() + array22.length() + array23.length() + array24.length());
}
