/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.InvalidPathHandleException;
import org.apache.hadoop.fs.PathHandle;
import org.apache.hadoop.hdfs.protocol.HdfsLocatedFileStatus;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class HdfsPathHandle
implements PathHandle {
    private static final long serialVersionUID = 13550764053544L;
    private final String path;
    private final Long mtime;
    private final Long inodeId;

    public HdfsPathHandle(String path, Optional<Long> inodeId, Optional<Long> mtime) {
        this.path = path;
        this.mtime = mtime.orElse(null);
        this.inodeId = inodeId.orElse(null);
    }

    public HdfsPathHandle(ByteBuffer bytes) throws IOException {
        if (null == bytes) {
            throw new IOException("Missing PathHandle");
        }
        HdfsProtos.HdfsPathHandleProto p = HdfsProtos.HdfsPathHandleProto.parseFrom(ByteString.copyFrom((ByteBuffer)bytes));
        this.path = p.getPath();
        this.mtime = p.hasMtime() ? Long.valueOf(p.getMtime()) : null;
        this.inodeId = p.hasInodeId() ? Long.valueOf(p.getInodeId()) : null;
    }

    public String getPath() {
        return this.path;
    }

    public void verify(HdfsLocatedFileStatus stat) throws InvalidPathHandleException {
        if (null == stat) {
            throw new InvalidPathHandleException("Could not resolve handle");
        }
        if (this.mtime != null && this.mtime.longValue() != stat.getModificationTime()) {
            throw new InvalidPathHandleException("Content changed");
        }
        if (this.inodeId != null && this.inodeId.longValue() != stat.getFileId()) {
            throw new InvalidPathHandleException("Wrong file");
        }
    }

    public ByteBuffer bytes() {
        HdfsProtos.HdfsPathHandleProto.Builder b = HdfsProtos.HdfsPathHandleProto.newBuilder();
        b.setPath(this.path);
        if (this.inodeId != null) {
            b.setInodeId(this.inodeId);
        }
        if (this.mtime != null) {
            b.setMtime(this.mtime);
        }
        return b.build().toByteString().asReadOnlyByteBuffer();
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (!HdfsPathHandle.class.equals(other.getClass())) {
            return false;
        }
        HdfsPathHandle o = (HdfsPathHandle)other;
        return this.getPath().equals(o.getPath());
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        sb.append("\"path\" : \"").append(this.path).append("\"");
        if (this.inodeId != null) {
            sb.append(",\"inodeId\" : ").append(this.inodeId);
        }
        if (this.mtime != null) {
            sb.append(",\"mtime\" : ").append(this.mtime);
        }
        sb.append(" }");
        return sb.toString();
    }
}

