/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.nativeaccess.transparency.win32;

import com.sun.jna.FromNativeContext;
import com.sun.jna.IntegerType;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.ptr.ByReference;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIFunctionMapper;
import com.sun.jna.win32.W32APITypeMapper;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.core.nativeaccess.transparency.win32.W32Errors;

public interface W32API
extends StdCallLibrary,
W32Errors {
    public static final Map UNICODE_OPTIONS = new HashMap(){
        {
            this.put("type-mapper", W32APITypeMapper.UNICODE);
            this.put("function-mapper", W32APIFunctionMapper.UNICODE);
        }
    };
    public static final Map ASCII_OPTIONS = new HashMap(){
        {
            this.put("type-mapper", W32APITypeMapper.ASCII);
            this.put("function-mapper", W32APIFunctionMapper.ASCII);
        }
    };
    public static final Map DEFAULT_OPTIONS = Boolean.getBoolean("w32.ascii") ? ASCII_OPTIONS : UNICODE_OPTIONS;
    public static final HANDLE INVALID_HANDLE_VALUE = new HANDLE(){

        public void setPointer(Pointer pointer) {
            throw new UnsupportedOperationException("Immutable reference");
        }
    };
    public static final HWND HWND_BROADCAST = new HWND(){

        public void setPointer(Pointer pointer) {
            throw new UnsupportedOperationException("Immutable reference");
        }
    };

    public static class HANDLE
    extends PointerType {
        public Object fromNative(Object object, FromNativeContext fromNativeContext) {
            Object object2 = super.fromNative(object, fromNativeContext);
            if (INVALID_HANDLE_VALUE.equals(object2)) {
                return INVALID_HANDLE_VALUE;
            }
            return object2;
        }
    }

    public static class HANDLEByReference
    extends ByReference {
        public HANDLEByReference() {
            this(null);
        }

        public HANDLEByReference(HANDLE hANDLE) {
            super(Pointer.SIZE);
            this.setValue(hANDLE);
        }

        public void setValue(HANDLE hANDLE) {
            this.getPointer().setPointer(0L, hANDLE != null ? hANDLE.getPointer() : null);
        }

        public HANDLE getValue() {
            Pointer pointer = this.getPointer().getPointer(0L);
            if (pointer == null) {
                return null;
            }
            if (INVALID_HANDLE_VALUE.getPointer().equals((Object)pointer)) {
                return INVALID_HANDLE_VALUE;
            }
            HANDLE hANDLE = new HANDLE();
            hANDLE.setPointer(pointer);
            return hANDLE;
        }
    }

    public static class HBITMAP
    extends HANDLE {
    }

    public static class HDC
    extends HANDLE {
    }

    public static class HICON
    extends HANDLE {
    }

    public static class HINSTANCE
    extends HANDLE {
    }

    public static class HMODULE
    extends HINSTANCE {
    }

    public static class HRGN
    extends HANDLE {
    }

    public static class HWND
    extends HANDLE {
    }

    public static class LONG_PTR
    extends IntegerType {
        public LONG_PTR() {
            this(0L);
        }

        public LONG_PTR(long l) {
            super(Pointer.SIZE, l);
        }
    }

    public static class LPARAM
    extends LONG_PTR {
        public LPARAM() {
            this(0L);
        }

        public LPARAM(long l) {
            super(l);
        }
    }

    public static class LRESULT
    extends LONG_PTR {
        public LRESULT() {
            this(0L);
        }

        public LRESULT(long l) {
            super(l);
        }
    }

    public static class SIZE_T
    extends ULONG_PTR {
        public SIZE_T() {
            this(0L);
        }

        public SIZE_T(long l) {
            super(l);
        }
    }

    public static class SSIZE_T
    extends LONG_PTR {
        public SSIZE_T() {
            this(0L);
        }

        public SSIZE_T(long l) {
            super(l);
        }
    }

    public static class UINT_PTR
    extends IntegerType {
        public UINT_PTR() {
            super(Pointer.SIZE);
        }

        public UINT_PTR(long l) {
            super(Pointer.SIZE, l);
        }

        public Pointer toPointer() {
            return Pointer.createConstant((long)this.longValue());
        }
    }

    public static class ULONG_PTR
    extends IntegerType {
        public ULONG_PTR() {
            this(0L);
        }

        public ULONG_PTR(long l) {
            super(Pointer.SIZE, l);
        }
    }

    public static class WPARAM
    extends UINT_PTR {
        public WPARAM() {
            this(0L);
        }

        public WPARAM(long l) {
            super(l);
        }
    }
}

