/*
 * Decompiled with CFR 0.152.
 */
package tr.view.criteria;

import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openide.util.NbBundle;
import tr.model.IDGenerator;
import tr.model.criteria.Criterion;
import tr.model.criteria.Value;
import tr.util.Observable;
import tr.util.Observer;

public class CriterionTableModel
extends AbstractTableModel
implements Observer {
    public static final String[] HEADINGS = new String[]{NbBundle.getMessage(CriterionTableModel.class, (String)"value")};
    public static final Class[] CLASSES = new Class[]{String.class};
    public static final TableCellRenderer[] RENDERERS = new TableCellRenderer[]{null};
    public static final TableCellEditor[] EDITORS = new TableCellEditor[]{null};
    private static final int[] MAX_WIDTHS = new int[]{200};
    private static final int[] MIN_WIDTHS = new int[]{200};
    private static final int[] PREF_WIDTHS = new int[]{200};
    protected final Criterion criterion;
    protected final IDGenerator idGenerator;

    public CriterionTableModel(Criterion criterion, IDGenerator idGenerator) {
        this.criterion = criterion;
        this.criterion.addObserver((Observer)this);
        this.idGenerator = idGenerator;
    }

    public int getColumnCount() {
        return CLASSES.length;
    }

    public Class getColumnClass(int column) {
        return CLASSES[column];
    }

    public String getColumnName(int column) {
        return HEADINGS[column];
    }

    public int getRowCount() {
        return this.criterion.values.size();
    }

    public Value getValueAt(int row) {
        return (Value)this.criterion.values.get(row);
    }

    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return this.getValueAt(row).getName();
            }
        }
        return "";
    }

    public boolean isCellEditable(int row, int column) {
        return true;
    }

    public void setValueAt(Object value, int row, int column) {
        if (row < this.criterion.values.size() && column == 0 && value instanceof String) {
            ((Value)this.criterion.values.get(row)).setName((String)value);
        }
    }

    public synchronized boolean moveDown(int row) {
        if (row < 0 || row > this.criterion.values.size() - 2) {
            return false;
        }
        Value value = (Value)this.criterion.values.get(row);
        this.criterion.values.set(row, this.criterion.values.get(row + 1));
        this.criterion.values.set(row + 1, (Observable)value);
        return true;
    }

    public synchronized boolean moveUp(int row) {
        if (row < 1 || row > this.criterion.values.size() - 1) {
            return false;
        }
        Value value = (Value)this.criterion.values.get(row);
        this.criterion.values.set(row, this.criterion.values.get(row - 1));
        this.criterion.values.set(row - 1, (Observable)value);
        return true;
    }

    public synchronized boolean removeRow(int row) {
        if (row < 0 || row > this.criterion.values.size() - 1) {
            return false;
        }
        return this.criterion.values.remove(this.criterion.values.get(row));
    }

    public synchronized boolean addRow() {
        return this.criterion.values.add((Observable)new Value("", this.idGenerator));
    }

    public void update(Observable observable, Object arg) {
        this.fireTableDataChanged();
    }

    public int[] getMaxWidths() {
        return MAX_WIDTHS;
    }

    public int[] getMinWidths() {
        return MIN_WIDTHS;
    }

    public int[] getPrefWidths() {
        return PREF_WIDTHS;
    }
}

