/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.favorites.templates;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.PasteAction;
import org.openide.actions.RenameAction;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplatesPanel
extends TopComponent
implements ExplorerManager.Provider {
    private ExplorerManager manager;
    private TemplateTreeView view;
    private static FileObject templatesRoot;
    private JButton addButton;
    private JPanel buttonsPanel;
    private JButton deleteButton;
    private JButton duplicateButton;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JButton newFolderButton;
    private JButton renameButton;
    private JLabel templatesLabel;
    private JPanel treePanel;

    public TemplatesPanel() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.getExplorerManager()));
        actionMap.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.getExplorerManager()));
        actionMap.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.getExplorerManager()));
        actionMap.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.getExplorerManager(), (boolean)true));
        this.initComponents();
        this.createTemplateView();
        this.treePanel.add((Component)((Object)this.view), "Center");
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.getExplorerManager(), (ActionMap)actionMap));
        this.initialize();
    }

    public ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            this.manager = new ExplorerManager();
        }
        return this.manager;
    }

    private void createTemplateView() {
        if (this.view == null) {
            this.view = new TemplateTreeView();
        }
        this.view.setRootVisible(false);
        this.view.setPopupAllowed(true);
        this.view.setDefaultActionAllowed(false);
    }

    private void initialize() {
        this.getExplorerManager().setRootContext(TemplatesPanel.getTemplateRootNode());
        this.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)new SelectionListener());
        this.deleteButton.setEnabled(false);
        this.renameButton.setEnabled(false);
        this.duplicateButton.setEnabled(false);
        this.moveUpButton.setEnabled(false);
        this.moveDownButton.setEnabled(false);
        this.addButton.setEnabled(true);
    }

    static Node getTemplateRootNode() {
        DataFolder dataFolder = DataFolder.findFolder((FileObject)TemplatesPanel.getTemplatesRoot());
        return new TemplateNode((Node)new FilterNode(dataFolder.getNodeDelegate(), dataFolder.createNodeChildren((DataFilter)new TemplateFilter())));
    }

    private void initComponents() {
        this.templatesLabel = new JLabel();
        this.treePanel = new JPanel();
        this.buttonsPanel = new JPanel();
        this.addButton = new JButton();
        this.newFolderButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.duplicateButton = new JButton();
        this.renameButton = new JButton();
        this.jSeparator2 = new JSeparator();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.jSeparator3 = new JSeparator();
        this.deleteButton = new JButton();
        this.setPreferredSize(new Dimension(500, 300));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.templatesLabel, (String)NbBundle.getBundle(TemplatesPanel.class).getString("LBL_TemplatesPanel_TemplatesLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add(this.templatesLabel, gridBagConstraints);
        this.treePanel.setBorder(BorderFactory.createEtchedBorder());
        this.treePanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 11, 0);
        this.add(this.treePanel, gridBagConstraints);
        this.buttonsPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getBundle(TemplatesPanel.class).getString("BTN_TemplatesPanel_Add"));
        this.addButton.setToolTipText(NbBundle.getMessage(TemplatesPanel.class, (String)"TT_TemplatesPanel_Add"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TemplatesPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.addButton, gridBagConstraints);
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TemplatesPanel.class, (String)"ACD_TemplatesPanel_Add"));
        Mnemonics.setLocalizedText((AbstractButton)this.newFolderButton, (String)NbBundle.getBundle(TemplatesPanel.class).getString("BTN_TemplatesPanel_NewFolder"));
        this.newFolderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TemplatesPanel.this.newFolderButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.newFolderButton, gridBagConstraints);
        this.newFolderButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TemplatesPanel.class, (String)"ACD_TemplatesPanel_New"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        this.buttonsPanel.add((Component)this.jSeparator1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.duplicateButton, (String)NbBundle.getBundle(TemplatesPanel.class).getString("BTN_TemplatesPanel_DuplicateButton"));
        this.duplicateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TemplatesPanel.this.duplicateButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.duplicateButton, gridBagConstraints);
        this.duplicateButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TemplatesPanel.class, (String)"ACD_TemplatesPanel_Duplicate"));
        Mnemonics.setLocalizedText((AbstractButton)this.renameButton, (String)NbBundle.getBundle(TemplatesPanel.class).getString("BTN_TemplatesPanel_RenameButton"));
        this.renameButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TemplatesPanel.this.renameButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.renameButton, gridBagConstraints);
        this.renameButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TemplatesPanel.class, (String)"ACD_TemplatesPanel_Rename"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        this.buttonsPanel.add((Component)this.jSeparator2, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.moveUpButton, (String)NbBundle.getBundle(TemplatesPanel.class).getString("BTN_TemplatesPanel_MoveUp"));
        this.moveUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TemplatesPanel.this.moveUpButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.moveUpButton, gridBagConstraints);
        this.moveUpButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TemplatesPanel.class, (String)"ACD_TemplatesPanel_MoveUp"));
        Mnemonics.setLocalizedText((AbstractButton)this.moveDownButton, (String)NbBundle.getBundle(TemplatesPanel.class).getString("BTN_TemplatesPanel_MoveDown"));
        this.moveDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TemplatesPanel.this.moveDownButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.moveDownButton, gridBagConstraints);
        this.moveDownButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TemplatesPanel.class, (String)"ACD_TemplatesPanel_MoveDown"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        this.buttonsPanel.add((Component)this.jSeparator3, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.deleteButton, (String)NbBundle.getBundle(TemplatesPanel.class).getString("BTN_TemplatesPanel_Delete"));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TemplatesPanel.this.deleteButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.deleteButton, gridBagConstraints);
        this.deleteButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TemplatesPanel.class, (String)"ACD_TemplatesPanel_Delete"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 11, 11, 8);
        this.add(this.buttonsPanel, gridBagConstraints);
    }

    private void moveDownButtonActionPerformed(ActionEvent actionEvent) {
        this.moveDown(this.manager.getSelectedNodes());
    }

    private void moveUpButtonActionPerformed(ActionEvent actionEvent) {
        this.moveUp(this.manager.getSelectedNodes());
    }

    private void newFolderButtonActionPerformed(ActionEvent actionEvent) {
        DataFolder dataFolder = TemplatesPanel.doNewFolder(this.manager.getSelectedNodes());
        assert (dataFolder != null) : "New DataFolder has been created.";
        try {
            Node[] nodeArray = this.manager.getSelectedNodes();
            Node node = null;
            node = nodeArray == null || nodeArray.length == 0 ? this.manager.getRootContext() : (nodeArray[0].isLeaf() ? nodeArray[0].getParentNode() : nodeArray[0]);
            node.getChildren().getNodes(true);
            Node node2 = node.getChildren().findChild(dataFolder.getName());
            assert (node2 != null) : "Node for subfolder found in nodes: " + Arrays.asList(node.getChildren().getNodes());
            this.manager.setSelectedNodes(new Node[]{node2});
            this.view.invokeInplaceEditing();
        }
        catch (PropertyVetoException propertyVetoException) {
            Logger.getLogger(TemplatesPanel.class.getName()).log(Level.WARNING, null, propertyVetoException);
        }
    }

    private void deleteButtonActionPerformed(ActionEvent actionEvent) {
        Node[] nodeArray = this.manager.getSelectedNodes();
        for (int i = 0; i < nodeArray.length; ++i) {
            try {
                nodeArray[i].destroy();
                continue;
            }
            catch (IOException iOException) {
                Logger.getLogger(TemplatesPanel.class.getName()).log(Level.WARNING, null, iOException);
            }
        }
    }

    private void duplicateButtonActionPerformed(ActionEvent actionEvent) {
        Node[] nodeArray = this.manager.getSelectedNodes();
        assert (nodeArray != null) : "Selected Nodes cannot be null.";
        assert (nodeArray.length == 1) : "One one node can be selected, but was " + Arrays.asList(nodeArray);
        TemplatesPanel.createDuplicateFromNode(nodeArray[0]);
    }

    private void renameButtonActionPerformed(ActionEvent actionEvent) {
        Node[] nodeArray = this.manager.getSelectedNodes();
        assert (nodeArray != null) : "Selected Nodes cannot be null.";
        assert (nodeArray.length == 1) : "One one node can be selected, but was " + Arrays.asList(nodeArray);
        this.view.invokeInplaceEditing();
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        TemplatesPanel.doAdd(this.manager.getSelectedNodes());
    }

    private static DataObject getDOFromNode(Node node) {
        DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
        assert (dataObject != null) : "DataObject for node " + node;
        return dataObject;
    }

    private static DataFolder getTargetFolder(Node[] nodeArray) {
        DataFolder dataFolder = null;
        if (nodeArray == null || nodeArray.length == 0) {
            dataFolder = DataFolder.findFolder((FileObject)TemplatesPanel.getTemplatesRoot());
        } else {
            dataFolder = (DataFolder)nodeArray[0].getLookup().lookup(DataFolder.class);
            if (dataFolder == null && nodeArray[0].isLeaf()) {
                Node node = nodeArray[0].getParentNode();
                dataFolder = (DataFolder)node.getLookup().lookup(DataFolder.class);
            }
        }
        return dataFolder;
    }

    static DataObject createTemplateFromFile(File file, DataFolder dataFolder) {
        if (file == null) {
            throw new IllegalArgumentException("Argument file cannot be null!");
        }
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        assert (fileObject != null) : "FileObject found for file " + file;
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Logger.getLogger(TemplatesPanel.class.getName()).log(Level.WARNING, null, dataObjectNotFoundException);
        }
        assert (dataObject != null) : "DataObject found for FileObject " + fileObject;
        DataFolder dataFolder2 = dataFolder == null ? DataFolder.findFolder((FileObject)TemplatesPanel.getTemplatesRoot()) : dataFolder;
        DataObject dataObject2 = null;
        try {
            dataObject2 = dataObject.copy(dataFolder2);
            dataObject2.setTemplate(true);
        }
        catch (IOException iOException) {
            Logger.getLogger(TemplatesPanel.class.getName()).log(Level.WARNING, null, iOException);
        }
        return dataObject2;
    }

    private static void doAdd(Node[] nodeArray) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(NbBundle.getBundle(TemplatesPanel.class).getString("LBL_TemplatesPanel_JFileChooser_Title"));
        jFileChooser.setApproveButtonText(NbBundle.getBundle(TemplatesPanel.class).getString("BTN_TemplatesPanel_JFileChooser_AddButtonName"));
        jFileChooser.setFileHidingEnabled(false);
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showOpenDialog(null);
        if (0 == n) {
            File file = jFileChooser.getSelectedFile();
            assert (file != null);
            TemplatesPanel.createTemplateFromFile(file, TemplatesPanel.getTargetFolder(nodeArray));
        }
    }

    private static DataFolder doNewFolder(Node[] nodeArray) {
        DataFolder dataFolder = null;
        DataFolder dataFolder2 = TemplatesPanel.getTargetFolder(nodeArray);
        if (dataFolder2 == null) {
            dataFolder2 = DataFolder.findFolder((FileObject)TemplatesPanel.getTemplatesRoot());
            assert (dataFolder2 != null) : "DataFolder found for FO " + TemplatesPanel.getTemplatesRoot();
        }
        try {
            dataFolder = DataFolder.create((DataFolder)dataFolder2, (String)NbBundle.getBundle(TemplatesPanel.class).getString("TXT_TemplatesPanel_NewFolderName"));
            assert (dataFolder != null) : "New subfolder found in folder " + dataFolder2;
        }
        catch (IOException iOException) {
            Logger.getLogger(TemplatesPanel.class.getName()).log(Level.WARNING, null, iOException);
        }
        return dataFolder;
    }

    static DataObject createDuplicateFromNode(Node node) {
        DataObject dataObject = TemplatesPanel.getDOFromNode(node);
        try {
            DataObject dataObject2 = dataObject.copy(dataObject.getFolder());
            FileObject fileObject = dataObject.getPrimaryFile();
            FileObject fileObject2 = dataObject2.getPrimaryFile();
            TemplatesPanel.setAttributes(fileObject2, TemplatesPanel.getAttributes(fileObject));
            return dataObject2;
        }
        catch (IOException iOException) {
            Logger.getLogger(TemplatesPanel.class.getName()).log(Level.WARNING, null, iOException);
            return null;
        }
    }

    private static HashMap<String, Object> getAttributes(FileObject fileObject) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Enumeration enumeration = fileObject.getAttributes();
        while (enumeration.hasMoreElements()) {
            Object object;
            String string = (String)enumeration.nextElement();
            if (string == null || (object = fileObject.getAttribute(string)) == null) continue;
            hashMap.put(string, object);
        }
        return hashMap;
    }

    private static void setAttributes(FileObject fileObject, HashMap<String, Object> hashMap) throws IOException {
        for (Map.Entry<String, Object> entry : hashMap.entrySet()) {
            fileObject.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    static FileObject getTemplatesRoot() {
        if (templatesRoot == null) {
            templatesRoot = Repository.getDefault().getDefaultFileSystem().findResource("Templates");
        }
        return templatesRoot;
    }

    private boolean isMoveUpEnabled(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1 || !nodeArray[0].isLeaf()) {
            return false;
        }
        int n = this.getNodePosition(nodeArray[0]);
        return n != -1 && n > 0;
    }

    private boolean isMoveDownEnabled(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1 || !nodeArray[0].isLeaf()) {
            return false;
        }
        int n = nodeArray[0].getParentNode().getChildren().getNodesCount();
        int n2 = this.getNodePosition(nodeArray[0]);
        return n2 != -1 && n2 < n - 1;
    }

    private int getNodePosition(Node node) {
        Index index = this.getIndexSupport(node);
        DataFolder dataFolder = (DataFolder)node.getParentNode().getLookup().lookup(DataFolder.class);
        dataFolder.getNodeDelegate().getChildren().getNodes(true);
        int n = index.indexOf(node);
        return n;
    }

    private Index getIndexSupport(Node node) {
        Node node2 = node.getParentNode();
        assert (node2 != null) : "Node " + node + " has a parent.";
        Index index = (Index)node2.getLookup().lookup(Index.class);
        assert (index != null) : "Node " + node2 + " has Index cookie.";
        return index;
    }

    private void moveUp(Node[] nodeArray) {
        assert (nodeArray != null) : "Nodes to moveUp cannot be null.";
        assert (nodeArray.length == 1) : "Only one node can be moveUp, not " + Arrays.asList(nodeArray);
        assert (nodeArray[0].isLeaf()) : "Only leaf node can be moveUp, not " + nodeArray[0];
        Node node = nodeArray[0];
        Index index = this.getIndexSupport(node);
        int n = this.getNodePosition(node);
        if (n == -1) {
            return;
        }
        index.moveUp(n);
        assert (n - 1 == this.getNodePosition(node)) : "Node " + node + " has been moved from " + n + " to pos " + this.getNodePosition(node);
    }

    private void moveDown(Node[] nodeArray) {
        assert (nodeArray != null) : "Nodes to moveDown cannot be null.";
        assert (nodeArray.length == 1) : "Only one node can be moveDown, not " + Arrays.asList(nodeArray);
        assert (nodeArray[0].isLeaf()) : "Only leaf node can be moveDown, not " + nodeArray[0];
        Node node = nodeArray[0];
        Index index = this.getIndexSupport(node);
        int n = this.getNodePosition(node);
        if (n == -1) {
            return;
        }
        index.moveDown(n);
        assert (n + 1 == this.getNodePosition(node)) : "Node " + node + " has been moved from " + n + " to pos " + this.getNodePosition(node);
    }

    private static class NewFolderAction
    extends NodeAction {
        private NewFolderAction() {
        }

        protected void performAction(Node[] nodeArray) {
            TemplatesPanel.doNewFolder(nodeArray);
        }

        protected boolean enable(Node[] nodeArray) {
            return nodeArray != null && nodeArray.length == 1;
        }

        public String getName() {
            return NbBundle.getBundle(TemplatesPanel.class).getString("BTN_TemplatesPanel_NewFolder");
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        protected boolean asynchronous() {
            return true;
        }
    }

    private static class AddAction
    extends NodeAction {
        private AddAction() {
        }

        protected void performAction(Node[] nodeArray) {
            TemplatesPanel.doAdd(nodeArray);
        }

        protected boolean enable(Node[] nodeArray) {
            return nodeArray != null && nodeArray.length == 1;
        }

        public String getName() {
            return NbBundle.getBundle(TemplatesPanel.class).getString("BTN_TemplatesPanel_Add");
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        protected boolean asynchronous() {
            return true;
        }
    }

    private static class DataFolderFilterChildren
    extends FilterNode.Children {
        public DataFolderFilterChildren(Node node) {
            super(node);
        }

        protected Node[] createNodes(Node node) {
            Node[] nodeArray = super.createNodes(node);
            Node[] nodeArray2 = new Node[nodeArray.length];
            for (int i = 0; i < nodeArray.length; ++i) {
                DataObject dataObject = TemplatesPanel.getDOFromNode(nodeArray[i]);
                nodeArray2[i] = dataObject.isTemplate() ? new TemplateNode(nodeArray[i], Children.LEAF) : new TemplateNode(nodeArray[i]);
            }
            return nodeArray2;
        }
    }

    private static class TemplateNode
    extends FilterNode {
        private static Action[] ACTIONS_ON_LEAF = new Action[]{SystemAction.get(CutAction.class), SystemAction.get(CopyAction.class), SystemAction.get(PasteAction.class), null, SystemAction.get(DeleteAction.class), SystemAction.get(RenameAction.class)};
        private static Action[] ACTIONS_ON_FOLDER = new Action[]{SystemAction.get(AddAction.class), SystemAction.get(NewFolderAction.class), null, SystemAction.get(CutAction.class), SystemAction.get(CopyAction.class), SystemAction.get(PasteAction.class), null, SystemAction.get(DeleteAction.class), SystemAction.get(RenameAction.class)};

        public TemplateNode(Node node) {
            this(node, (Children)new DataFolderFilterChildren(node), new InstanceContent());
        }

        private TemplateNode(Node node, Children children) {
            this(node, children, new InstanceContent());
        }

        private TemplateNode(Node node, Children children, InstanceContent instanceContent) {
            super(node, children, (Lookup)new ProxyLookup(new Lookup[]{new AbstractLookup((AbstractLookup.Content)instanceContent), node.getLookup()}));
            DataObject dataObject = TemplatesPanel.getDOFromNode(node);
            if (dataObject.isValid()) {
                DataFolder dataFolder = null;
                if (dataObject instanceof DataFolder) {
                    dataFolder = (DataFolder)dataObject;
                } else if (dataObject.getPrimaryFile().getParent() != null && dataObject.getPrimaryFile().getParent().isValid()) {
                    dataFolder = dataObject.getFolder();
                }
                if (dataFolder != null) {
                    instanceContent.add((Object)new DataFolder.Index(dataFolder, (Node)this));
                }
            }
            instanceContent.add((Object)this);
        }

        public Action[] getActions(boolean bl) {
            return this.isLeaf() ? ACTIONS_ON_LEAF : ACTIONS_ON_FOLDER;
        }

        public Action getPreferredAction() {
            return null;
        }

        public void setName(String string) {
            FileObject fileObject = (FileObject)this.getLookup().lookup(FileObject.class);
            HashMap hashMap = TemplatesPanel.getAttributes(fileObject);
            super.setName(string);
            try {
                TemplatesPanel.setAttributes(fileObject, hashMap);
            }
            catch (IOException iOException) {
                Logger.getLogger(TemplatesPanel.class.getName()).log(Level.WARNING, null, iOException);
            }
        }
    }

    private static final class TemplateFilter
    implements DataFilter {
        private TemplateFilter() {
        }

        public boolean acceptDataObject(DataObject dataObject) {
            return this.acceptTemplate(dataObject);
        }

        private boolean acceptTemplate(DataObject dataObject) {
            if (dataObject.isTemplate() || dataObject instanceof DataFolder) {
                Object object = dataObject.getPrimaryFile().getAttribute("simple");
                return object == null || Boolean.TRUE.equals(object);
            }
            return false;
        }
    }

    private class SelectionListener
    implements PropertyChangeListener {
        private SelectionListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                final Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
                TemplatesPanel.this.deleteButton.setEnabled(nodeArray != null && nodeArray.length > 0);
                TemplatesPanel.this.renameButton.setEnabled(nodeArray != null && nodeArray.length == 1);
                TemplatesPanel.this.duplicateButton.setEnabled(nodeArray != null && nodeArray.length == 1 && nodeArray[0].isLeaf());
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TemplatesPanel.this.moveUpButton.setEnabled(TemplatesPanel.this.isMoveUpEnabled(nodeArray));
                        TemplatesPanel.this.moveDownButton.setEnabled(TemplatesPanel.this.isMoveDownEnabled(nodeArray));
                    }
                });
            }
        }
    }

    private static class TemplateTreeView
    extends BeanTreeView {
        private Action startEditing;

        private TemplateTreeView() {
        }

        private void invokeInplaceEditing() {
            Action action;
            if (this.startEditing == null && (action = this.tree.getActionMap().get("startEditing")) != null && action instanceof Action) {
                this.startEditing = action;
            }
            assert (this.startEditing != null) : "startEditing is on tree ActionMap " + Arrays.asList(this.tree.getActionMap().keys());
            this.startEditing.actionPerformed(new ActionEvent(this.tree, 0, "startEditing"));
        }
    }
}

