/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.execution;

import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import org.netbeans.core.execution.TaskThreadGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WindowTable
extends HashMap<Window, TaskThreadGroup> {
    static final long serialVersionUID = -1494996298725028533L;
    private WindowListener winListener;
    private HashMap<ThreadGroup, ArrayList<Window>> windowMap = new HashMap(16);
    private static Frame shOwnerFrame;

    public WindowTable() {
        super(16);
        this.winListener = new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                Window window = (Window)windowEvent.getSource();
                WindowTable.this.removeWindow(window);
                window.removeWindowListener(this);
            }
        };
    }

    public synchronized void putTaskWindow(Window window, TaskThreadGroup taskThreadGroup) {
        ArrayList<Window> arrayList = this.windowMap.get(taskThreadGroup);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.windowMap.put(taskThreadGroup, arrayList);
        }
        arrayList.add(window);
        window.addWindowListener(this.winListener);
        super.put(window, taskThreadGroup);
    }

    public TaskThreadGroup getThreadGroup(Window window) {
        return (TaskThreadGroup)super.get(window);
    }

    void closeGroup(ThreadGroup threadGroup) {
        ArrayList<Window> arrayList = this.windowMap.get(threadGroup);
        if (arrayList == null) {
            return;
        }
        for (Window window : arrayList) {
            window.setVisible(false);
            this.remove(window);
            if (window == WindowTable.getSharedOwnerFrame()) continue;
            window.dispose();
        }
        this.windowMap.remove(threadGroup);
    }

    private static Frame getSharedOwnerFrame() {
        if (shOwnerFrame != null) {
            return shOwnerFrame;
        }
        try {
            Class<?> clazz = Class.forName("javax.swing.SwingUtilities");
            Method method = clazz.getDeclaredMethod("getSharedOwnerFrame", new Class[0]);
            method.setAccessible(true);
            shOwnerFrame = (Frame)method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return shOwnerFrame;
    }

    boolean hasWindows(ThreadGroup threadGroup) {
        ArrayList<Window> arrayList = this.windowMap.get(threadGroup);
        return arrayList != null && arrayList.size() != 0 && !this.hiddenWindows(arrayList);
    }

    private boolean hiddenWindows(ArrayList<Window> arrayList) {
        for (Window window : arrayList) {
            if (!window.isVisible()) continue;
            return false;
        }
        return true;
    }

    private void removeWindow(Window window) {
        Object v = this.get(window);
        if (v == null) {
            return;
        }
        this.remove(window);
        ArrayList<Window> arrayList = this.windowMap.get(v);
        if (arrayList == null) {
            return;
        }
        arrayList.remove(window);
    }
}

