/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.loaders;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.openide.xml.EntityCatalog;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class RuntimeCatalog
extends EntityCatalog {
    private Map<String, String> id2uri;
    private Map<String, String> id2resource;
    private Map<String, ClassLoader> id2loader;

    public InputSource resolveEntity(String string, String string2) throws IOException, SAXException {
        String string3 = this.name2uri(string);
        InputStream inputStream = this.mapResource(string);
        if (string3 != null) {
            InputSource inputSource = new InputSource(string3);
            inputSource.setPublicId(string);
            return inputSource;
        }
        if (inputStream != null) {
            string2 = "java:resource:" + this.id2resource.get(string);
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setPublicId(string);
            return inputSource;
        }
        return null;
    }

    public void registerCatalogEntry(String string, String string2) {
        if (this.id2uri == null) {
            this.id2uri = new HashMap<String, String>();
        }
        this.id2uri.put(string, string2);
    }

    public void registerCatalogEntry(String string, String string2, ClassLoader classLoader) {
        if (this.id2resource == null) {
            this.id2resource = new HashMap<String, String>();
        }
        this.id2resource.put(string, string2);
        if (classLoader != null) {
            if (this.id2loader == null) {
                this.id2loader = new HashMap<String, ClassLoader>();
            }
            this.id2loader.put(string, classLoader);
        }
    }

    private String name2uri(String string) {
        if (string == null || this.id2uri == null) {
            return null;
        }
        return this.id2uri.get(string);
    }

    private InputStream mapResource(String string) {
        if (string == null || this.id2resource == null) {
            return null;
        }
        String string2 = this.id2resource.get(string);
        ClassLoader classLoader = null;
        if (string2 == null) {
            return null;
        }
        if (this.id2loader != null) {
            classLoader = this.id2loader.get(string);
        }
        if (classLoader == null) {
            return ClassLoader.getSystemResourceAsStream(string2);
        }
        return classLoader.getResourceAsStream(string2);
    }
}

