/*
 * Decompiled with CFR 0.152.
 */
package liquibase.configuration;

import java.util.logging.Level;
import liquibase.Scope;

public interface ConfigurationValueConverter<DataType> {
    public static final ConfigurationValueConverter<Level> LOG_LEVEL = value -> {
        if (value == null) {
            return null;
        }
        if (value instanceof Level) {
            return (Level)value;
        }
        String stringLevel = String.valueOf(value).toUpperCase();
        if (stringLevel.equals("DEBUG")) {
            return Level.FINE;
        }
        if (stringLevel.equals("WARN")) {
            return Level.WARNING;
        }
        if (stringLevel.equals("ERROR")) {
            return Level.SEVERE;
        }
        try {
            return Level.parse(stringLevel);
        }
        catch (IllegalArgumentException e2) {
            Scope.getCurrentScope().getUI().sendErrorMessage("WARNING:  Unknown log level " + stringLevel + ". Defaulting to 'INFO'");
            return Level.INFO;
        }
    };

    public DataType convert(Object var1) throws IllegalArgumentException;
}

