/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.OrderByElement;

public class KeepExpression
extends ASTNodeAccessImpl
implements Expression {
    private String name;
    private List<OrderByElement> orderByElements;
    private boolean first = false;

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public void setOrderByElements(List<OrderByElement> list) {
        this.orderByElements = list;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isFirst() {
        return this.first;
    }

    public void setFirst(boolean bl2) {
        this.first = bl2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("KEEP (").append(this.name);
        stringBuilder.append(" ").append(this.first ? "FIRST" : "LAST").append(" ");
        this.toStringOrderByElements(stringBuilder);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private void toStringOrderByElements(StringBuilder stringBuilder) {
        if (this.orderByElements != null && !this.orderByElements.isEmpty()) {
            stringBuilder.append("ORDER BY ");
            for (int i2 = 0; i2 < this.orderByElements.size(); ++i2) {
                if (i2 > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.orderByElements.get(i2).toString());
            }
        }
    }

    public KeepExpression withName(String string) {
        this.setName(string);
        return this;
    }

    public KeepExpression withOrderByElements(List<OrderByElement> list) {
        this.setOrderByElements(list);
        return this;
    }

    public KeepExpression withFirst(boolean bl2) {
        this.setFirst(bl2);
        return this;
    }

    public KeepExpression addOrderByElements(OrderByElement ... orderByElementArray) {
        List list = Optional.ofNullable(this.getOrderByElements()).orElseGet(ArrayList::new);
        Collections.addAll(list, orderByElementArray);
        return this.withOrderByElements(list);
    }

    public KeepExpression addOrderByElements(Collection<? extends OrderByElement> collection) {
        List list = Optional.ofNullable(this.getOrderByElements()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withOrderByElements(list);
    }
}

