/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.schema;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.repackaged.net.sf.jsqlparser.schema.MultiPartName;

public final class Server
implements MultiPartName {
    public static final Pattern SERVER_PATTERN = Pattern.compile("\\[([^\\]]+?)(?:\\\\([^\\]]+))?\\]");
    private String serverName;
    private String instanceName;
    private String simpleName;

    public Server(String string) {
        if (string != null) {
            Matcher matcher = SERVER_PATTERN.matcher(string);
            if (!matcher.find()) {
                this.simpleName = string;
                return;
            }
            this.setServerName(matcher.group(1));
            this.setInstanceName(matcher.group(2));
        }
    }

    public Server(String string, String string2) {
        this.setServerName(string);
        this.setInstanceName(string2);
    }

    public final String getServerName() {
        return this.serverName;
    }

    public final void setServerName(String string) {
        this.serverName = string;
    }

    public final String getInstanceName() {
        return this.instanceName;
    }

    public final void setInstanceName(String string) {
        this.instanceName = string;
    }

    @Override
    public final String getFullyQualifiedName() {
        if (this.serverName != null && !this.serverName.isEmpty() && this.instanceName != null && !this.instanceName.isEmpty()) {
            return String.format("[%s\\%s]", this.serverName, this.instanceName);
        }
        if (this.serverName != null && !this.serverName.isEmpty()) {
            return String.format("[%s]", this.serverName);
        }
        if (this.simpleName != null && !this.simpleName.isEmpty()) {
            return this.simpleName;
        }
        return "";
    }

    public final String toString() {
        return this.getFullyQualifiedName();
    }

    public final Server withServerName(String string) {
        this.setServerName(string);
        return this;
    }

    public final Server withInstanceName(String string) {
        this.setInstanceName(string);
        return this;
    }
}

